import { useState } from "react";
import Header from "../../Layouts/Header/Header";
import MainContainer from "../../UI/MainContainer";
import SubMainContainer from "../../UI/SubMainContainer";
import SideBar from "../../Layouts/SideBar/SideBar";
import CreateBrand from "../../Settings/Brands/CreateBrand";
import { useNavigate } from "react-router-dom";
const CreateNewBrand = () => {
    const navigate = useNavigate();
    const [errors, setErrors] = useState({
        brandNameError: "",
        brandImageError: "",
        variantNameError: "",
        variantImageError: '',
        variantBatteryError: "",
        modelNameError: ""

    }
    )
    return (
        <>
            <MainContainer>
                <Header />
                <SubMainContainer>
                    <SideBar />
                    <SubMainContainer SubMainContainerCustomClass="rightCol">
                        <div className="contentContainer">

                            <h2>
                                <a>
                                    <span class="material-symbols-rounded mt-l black" onClick={() => { navigate(-1) }}>arrow_back</span>
                                </a>

                                Add new Brand</h2>
                            <CreateBrand errors={errors} setErrors={setErrors} />
                        </div>
                    </SubMainContainer>

                </SubMainContainer>
            </MainContainer>
        </>
    );
};

export default CreateNewBrand;
