import React from 'react'
import Header from '../../Layouts/Header/Header'
import MainContainer from '../../UI/MainContainer'
import SubMainContainer from '../../UI/SubMainContainer'
import SideBar from '../../Layouts/SideBar/SideBar'
import BrandEdit from '../../Settings/Brands/BrandEdit'
import { useNavigate } from 'react-router-dom'

export default function EditBrand() {
    const navigate = useNavigate();
    return (
        <>

            <MainContainer>
                <Header />
                <SubMainContainer>
                    <SideBar />
                    <SubMainContainer SubMainContainerCustomClass="rightCol">
                        <div className="contentContainer">

                            <h2>
                                <a>
                                    <span class="material-symbols-rounded mt-l black" onClick={() => { navigate(-1) }}>arrow_back</span>
                                </a>

                                Edit Brand</h2>
                            <BrandEdit />
                        </div>
                    </SubMainContainer>
                </SubMainContainer>
            </MainContainer>
        </>
    )
}
