import { addOns } from "./addOnConfig";
export const initialStatefields = [
  {
    package_account_type: "4",
    package: "1",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter Plan Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "booking_time",
        object_key: "booking_time",
        defaultValue: true,
        displayLabel: "Booking time",
        type: "radio",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: "1",
            displayValue: "7am-11pm",
          },
          {
            id: 2,
            value: "2",
            displayValue: "11pm-7am",
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "radio",
        hidden: false,
        placeholder: "Select Charge Rate",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        object_key: "addons",
        displayLabel: "Add-ons",
        divCustomClass: "fieldGroup",
        type: "label",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      ///
      // {
      //   id: "package_service_fee",
      //   object_key: "service_fee",
      //   displayLabel: "Service Fee",
      //   type: "label",
      //   config: {
      //     dataType: "",
      //   },
      //   divClass: "",
      //   multiElement: [
      //     {
      //       id: "package_service_fee",
      //       name: "package_service_fee",
      //       object_key: "service_fee",
      //       Object_type: "service_fee",
      //       type: "radio",
      //       placeholder: "Select service type",
      //       config: {
      //         dataType: "radio",
      //       },
      //       options: [
      //         {
      //           id: 1,
      //           value: "0",
      //           displayValue: "Free",
      //         },
      //         {
      //           id: 2,
      //           value: "input",
      //           displayValue: "Enter Price",
      //         },
      //       ],
      //       value: "",
      //       validation: {
      //         required: false,
      //       },
      //       valid: false,
      //     },
      //     {
      //       id: "package_service_fee",
      //       type: "input",
      //       min:0,
      //       Object_type: "service_fee",
      //       placeholder: "Enter Service Fee",
      //       config: {
      //         dataType: "number",
      //       },
      //       value: "",
      //       validation: {
      //         required: false,
      //       },
      //       hidden: true,
      //       valid: false,
      //     },
      //   ],
      //   value: "",
      //   validation: {
      //     required: false,
      //   },
      //   valid: false,
      // },

      {
        id: "package_service_fee_without_add_on",
        object_key: "pack_service_fee",
        displayLabel: "Service fee",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_service_fee_without_add_on",
            type: "input",
            min: 0,
            Object_type: "pack_service_fee",
            em_label:"Without add-ons",
            placeholder: "Enter service fee",
            additionalClass: "mt-0",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            object_key: "pack_service_fee",
            type: "input",
            Object_type: "pack_service_fee",
            em_label:"With add-ons",
            placeholder: "Enter service fee",
            additionalClass: "mt-0",
            config: {
              dataType: "number",
            },

            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        displayLabel: "Parking",
        min: 0,
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
    ],
  },

  {
    package_account_type: "4",
    package: "18",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter Package Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "booking_time",
        object_key: "booking_time",
        defaultValue: true,
        displayLabel: "Booking time",
        type: "radio",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: "1",
            displayValue: "7am-11pm",
          },
          {
            id: 2,
            value: "2",
            displayValue: "11pm-7am",
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      // {
      //   id: "package_price",
      //   displayLabel: "Package price",
      //   type: "input",
      //   min:0,
      //   placeholder: "Enter Price",
      //   config: {
      //     dataType: "number",
      //   },
      //   value: "",
      //   validation: {
      //     required: true,
      //   },
      //   valid: false,
      // },
      // {
      //   id: "package_duration",
      //   object_key: "pack_duration",
      //   displayLabel: "Package duration",
      //   type: "multi",
      //   divClass: "multiOption",
      //   placeholder: "select Package Duration",
      //   config: {
      //     dataType: "select",
      //   },
      //   options: [],
      //   value: "",
      //   multiElement: [
      //     {
      //       id: "package_duration",
      //       type: "input",
      //       placeholder: "Enter Price",
      //       config: {
      //         dataType: "number",
      //       },
      //       value: "",
      //       validation: {
      //         required: true,
      //       },
      //       valid: false,
      //     },
      //     {
      //       id: "package_duration_unit",
      //       object_key: "package_duration_unit",
      //       type: "select",
      //       placeholder: "select Package Duration",
      //       config: {
      //         dataType: "text",
      //       },
      //       options: [
      //         {
      //           id: 1,
      //           value: "w",
      //           displayValue: "Week",
      //         },
      //         {
      //           id: 2,
      //           value: "m",
      //           displayValue: "Month",
      //         },
      //         {
      //           id: 3,
      //           value: "y",
      //           displayValue: "Year",
      //         },
      //       ],
      //       value: "",
      //       validation: {
      //         required: true,
      //       },
      //       valid: false,
      //     },
      //   ],
      //   validation: {
      //     required: true,
      //   },
      //   valid: false,
      // },
      {
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "radio",
        placeholder: "Select Charge Rate",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "addons",
        object_key: "addons",
        displayLabel: "Add-ons",
        divCustomClass: "fieldGroup",
        type: "label",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        displayLabel: "Parking",
        min: 0,
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
    ],
  },

  {
    package_account_type: "1",
    package: "16",
    dynamic: true,
    addons: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter Plan Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_price",
        displayLabel: "Package price",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter Package Price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_max_allowed_booking",
        displayLabel: "Booking limit",
        type: "input",
        min: 0,
        placeholder: "Enter Number",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Package duration",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "Select Duration",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "booking_time",
        object_key: "booking_time",
        displayLabel: "Booking time",
        type: "radio",
        hidden: false,
        defaultValue: true,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: "1",
            displayValue: "7am-11pm",
          },
          {
            id: 2,
            value: "2",
            displayValue: "11pm-7am",
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "radio",
        hidden: false,
        placeholder: "Select Charge Rate",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },

      {
        id: "package_auto_renewed",
        name: "package_auto_renewed",
        displayLabel: "Auto renew",
        type: "radio",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: "package_auto_renewed",
            value: "1",
            displayValue: "Yes",
          },
          {
            id: "package_auto_renewed",
            value: "0",
            displayValue: "No",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        displayLabel: "Parking",
        min: 0,
        type: "input",
        defaultValue: true,
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
        value: "",
      },
    ],
  },

  {
    package_account_type: "1",
    package: "14",
    dynamic: true,
    addons: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter Package Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_price",
        displayLabel: "Package price",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter Package Price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_max_allowed_booking",
        displayLabel: "Booking limit",
        min: 0,
        type: "input",
        placeholder: "Enter Number",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Package duration",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "Select Duration",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "radio",
        hidden: false,
        placeholder: "Select Charge Rate",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "booking_time",
        object_key: "booking_time",
        displayLabel: "Booking time",
        type: "radio",
        hidden: false,
        defaultValue: true,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: "1",
            displayValue: "7am-11pm",
          },
          {
            id: 2,
            value: "2",
            displayValue: "11pm-7am",
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "service_fee",
            name: "package_service_fee",
            object_key: "service_fee",
            disableFieldGroup: true,
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },

      {
        id: "package_auto_renewed",
        name: "package_auto_renewed",
        displayLabel: "Auto renew",
        type: "radio",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: "package_auto_renewed",
            value: "1",
            displayValue: "Yes",
          },
          {
            id: "package_auto_renewed",
            value: "0",
            displayValue: "No",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        min: 0,
        displayLabel: "Parking",
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
    ],
  },
  {
    package_account_type: "1",
    package: "24",
    dynamic: true,
    addons: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter Package Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_price",
        displayLabel: "Package price",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter Package Price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_max_allowed_booking",
        displayLabel: "Booking limit",
        min: 0,
        type: "input",
        placeholder: "Enter Number",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Package duration",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "Select Duration",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "radio",
        hidden: false,
        placeholder: "Select Charge Rate",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "booking_time",
        object_key: "booking_time",
        displayLabel: "Booking time",
        type: "radio",
        hidden: false,
        defaultValue: true,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: "1",
            displayValue: "7am-11pm",
          },
          {
            id: 2,
            value: "2",
            displayValue: "11pm-7am",
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },

      {
        id: "package_auto_renewed",
        name: "package_auto_renewed",
        displayLabel: "Auto renew",
        type: "radio",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: "package_auto_renewed",
            value: "1",
            displayValue: "Yes",
          },
          {
            id: "package_auto_renewed",
            value: "0",
            displayValue: "No",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        min: 0,
        displayLabel: "Parking",
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
    ],
  },

  {
    package_account_type: "3",
    package: "4",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter Plan  Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_price",
        displayLabel: "Package price",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter Package Price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_credit_amount",
        displayLabel: "Package credits",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter Package Credits",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_credit_duration",
        object_key: "credit_duration",
        displayLabel: "Credit expiry",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "select Month",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_credit_duration",
            type: "input",
            min: 0,
            Object_type: "credit_duration",
            additionalClass: "mt-0",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_credit_duration_unit",
            object_key: "credit_duration",
            type: "select",
            Object_type: "credit_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "booking_time",
        object_key: "booking_time",
        displayLabel: "Booking time",
        type: "radio",
        hidden: false,
        defaultValue: true,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: "1",
            displayValue: "7am-11pm",
          },
          {
            id: 2,
            value: "2",
            displayValue: "11pm-7am",
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },

      {
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "radio",
        placeholder: "Select Charge Rate",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service  fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },

      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        displayLabel: "Parking",
        min: 0,
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
    ],
  },

  {
    package_account_type: "3",
    package: "5",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter Package Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "subscription_linked_package_id",
        object_key: "package_link",
        displayLabel: "Select subscription to be linked",
        type: "select",
        placeholder: "select subscription to be Linked",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "text",
        },
        options: [
          {
            id: 1,
            value: "W",
            displayValue: "Week",
          },
          {
            id: 2,
            value: "M",
            displayValue: "Month",
          },
          {
            id: 3,
            value: "Y",
            displayValue: "Year",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Package duration",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "Select duration",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "package_price",
        displayLabel: "Package price",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter Package Price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "calculation",
        type: "calculation",
        value: "",
        data: "",
        config: {
          dataType: "",
        },
        validation: {
          required: false,
        },
      },
      {
        id: "package_credit_amount",
        displayLabel: "Package credits",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter Package Credits",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_credit_duration",
        object_key: "credit_duration",
        displayLabel: "Credits expiry",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "Select Duration",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_credit_duration",
            type: "input",
            min: 0,
            Object_type: "credit_duration",
            additionalClass: "mt-0",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_credit_duration_unit",
            object_key: "credit_duration",
            type: "select",
            Object_type: "credit_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },

      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        displayLabel: "Parking",
        min: 0,
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
    ],
  },

  {
    package_account_type: "5",
    package: "3",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter Plan Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "booking_time",
        object_key: "booking_time",
        displayLabel: "Booking time",
        type: "radio",
        hidden: false,
        defaultValue: true,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: "1",
            displayValue: "7am-11pm",
          },
          {
            id: 2,
            value: "2",
            displayValue: "11pm-7am",
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
	{
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
	multiElement: [
          {
            id: "package_charge_rate",
            name: "package_charge_rate",
            disableFieldGroup: true,
            object_key: "charge_rate",
            Object_type: "charge_rate",
            type: "radio",
            placeholder: "Charge rate",
            config: {
              dataType: "radio",
            },
            options: [
		  {
		     id: 3,
		     value: "input",
		     displayValue: "Custom price",
		  },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_charge_rate",
            type: "input",
            min: 0,
            Object_type: "charge_rate",
            placeholder: "Enter charge rate",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service  fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        displayLabel: "Parking",
        min: 0,
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
    ],
  },

  {
    package_account_type: "5",
    package: "6",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter Plan Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_price",
        displayLabel: "Package price",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter package Price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_max_allowed_booking",
        displayLabel: "Booking limit",
        type: "input",
        min: 0,
        placeholder: "Enter Number",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "booking_time",
        object_key: "booking_time",
        displayLabel: "Booking time",
        type: "radio",
        hidden: false,
        defaultValue: true,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: "1",
            displayValue: "7am-11pm",
          },
          {
            id: 2,
            value: "2",
            displayValue: "11pm-7am",
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Package duration",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "Select Duration",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "radio",
        placeholder: "Select Charge Rate",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service  fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_auto_renewed",
        name: "package_auto_renewed",
        displayLabel: "Auto renew",
        type: "radio",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: "package_auto_renewed",
            value: "1",
            displayValue: "Yes",
          },
          {
            id: "package_auto_renewed",
            value: "0",
            displayValue: "No",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        displayLabel: "Parking",
        type: "input",
        min: 0,
        defaultValue: true,
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },

      //addons
    ],
  },

  {
    package_account_type: "2",
    package: "2",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Voucher name",
        type: "input",
        placeholder: "Enter voucher Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_price",
        displayLabel: "Voucher price",
        icon: "attach_money",
        type: "input",
        min: 0,
        placeholder: "Enter voucher  Price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_max_allowed_booking",
        displayLabel: "Booking limit",
        type: "input",
        min: 0,
        placeholder: "Enter Number",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Voucher expiry",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "select Month",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "radio",
        placeholder: "Select Charge Rate",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },

      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        min: 0,
        displayLabel: "Parking",
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
    ],
  },

  {
    package_account_type: "2",
    package: "23",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Voucher name",
        type: "input",
        placeholder: "Enter Voucher Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_credit_amount",
        displayLabel: "Voucher credits",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter Voucher Credits",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_credit_duration",
        object_key: "credit_duration",
        displayLabel: "Credits expiry",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "select Month",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_credit_duration",
            type: "input",
            additionalClass: "mt-0",
            min: 0,
            Object_type: "credit_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_credit_duration_unit",
            additionalClass: "mt-0",
            object_key: "credit_duration",
            type: "select",
            Object_type: "credit_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
    ],
  },

  {
    package_account_type: "2",
    package: "20",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Voucher name",
        type: "input",
        placeholder: "Enter voucher Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_credit_amount",
        displayLabel: "Voucher credits",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter Voucher Credits",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "package_max_allowed_booking",
        object_key: "max_booking",
        displayLabel: "Booking limit",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_max_allowed_booking",
            name: "package_max_allowed_booking",
            disableFieldGroup: true,
            object_key: "max_booking",
            Object_type: "max_booking",
            type: "radio",
            placeholder: "Select Custom Value",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "unlimited",
                displayValue: "Unlimited",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Custom Limit",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_max_allowed_booking",
            type: "input",
            min: 0,
            Object_type: "max_booking",
            placeholder: "Enter Custom Limit",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },

      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Voucher expiry",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "select Month",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "radio",
        placeholder: "Select Charge Rate",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        object_key: "addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service  fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        displayLabel: "Parking",
        type: "input",
        min: 0,
        defaultValue: true,
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
    ],
  },

  {
    package_account_type: "2",
    package: "21",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Voucher name",
        type: "input",
        placeholder: "Enter voucher Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_price",
        displayLabel: "Voucher price",
        icon: "attach_money",
        type: "input",
        min: 0,
        placeholder: "Enter voucher Price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "package_max_allowed_booking",
        object_key: "max_booking",
        displayLabel: "Booking limit",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_max_allowed_booking",
            name: "package_max_allowed_booking",
            disableFieldGroup: true,
            object_key: "max_booking",
            Object_type: "max_booking",
            type: "radio",
            placeholder: "Select Custom Value",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "unlimited",
                displayValue: "Unlimited",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Custom Limit",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_max_allowed_booking",
            type: "input",
            min: 0,
            Object_type: "max_booking",
            placeholder: "Enter Custom Limit",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },

      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Voucher expiry",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "select Month",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_charge_rate",
        object_key: "charge_rate",
        displayLabel: "Charge rate",
        type: "radio",
        placeholder: "Select Charge Rate",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },

      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
    ],
  },

  {
    package_account_type: "2",
    package: "22",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Voucher name",
        type: "input",
        placeholder: "Enter voucher Name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_credit_amount",
        displayLabel: "Voucher credits",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter voucher Credits",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_credit_duration",
        object_key: "credit_duration",
        displayLabel: "Credits expiry",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "select Month",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_credit_duration",
            type: "input",
            additionalClass: "mt-0",
            min: 0,
            Object_type: "credit_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_credit_duration_unit",
            object_key: "credit_duration",
            additionalClass: "mt-0",
            type: "select",
            Object_type: "credit_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "batterytype",
        object_key: "battery_type",
        displayLabel: "Battery type",
        type: "radio",
        placeholder: "Select battery type",
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: 1,
            value: ".58",
            displayValue: "$0.58",
          },
          {
            id: 2,
            value: "unlimited",
            displayValue: "Unlimited",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Add-ons",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
    ],
  },
  // new fielsd

  {
    package_account_type: "6",
    package: "26",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter package name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Package duration",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "Select Duration",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_max_allowed_booking",
        displayLabel: "No. of services",
        type: "input",
        min: 0,
        placeholder: "Enter Number",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_price",
        displayLabel: "Package price",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter package price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_auto_renewed",
        name: "package_auto_renewed",
        displayLabel: "Auto renew",
        type: "radio",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: "package_auto_renewed",
            value: "1",
            displayValue: "Yes",
          },
          {
            id: "package_auto_renewed",
            value: "0",
            displayValue: "No",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        min: 0,
        displayLabel: "Parking",
        placeholder:"Inclusive upto $2",
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Services",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
    ],
  },
  {
    package_account_type: "3",
    package: "25",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter package name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Package duration",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "Select Duration",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_max_allowed_booking",
        displayLabel: "No. of services",
        type: "input",
        min: 0,
        placeholder: "Enter Number",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_price",
        displayLabel: "Package price",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter package price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_auto_renewed",
        name: "package_auto_renewed",
        displayLabel: "Auto renew",
        type: "radio",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: "package_auto_renewed",
            value: "1",
            displayValue: "Yes",
          },
          {
            id: "package_auto_renewed",
            value: "0",
            displayValue: "No",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        min: 0,
        displayLabel: "Parking",
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Services",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
    ],
  },
  {
    package_account_type: "5",
    package: "27",
    dynamic: true,
    form: [
      {
        id: "package_name",
        displayLabel: "Package name",
        type: "input",
        placeholder: "Enter package name",
        config: {
          dataType: "text",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_duration",
        object_key: "pack_duration",
        displayLabel: "Package duration",
        type: "label",
        divClass: "xType alignBottom",
        placeholder: "Select Duration",
        config: {
          dataType: "",
        },
        options: [],
        value: "",
        multiElement: [
          {
            id: "package_duration",
            additionalClass: "mt-0",
            type: "input",
            min: 0,
            Object_type: "pack_duration",
            placeholder: "Enter Number",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
          {
            id: "package_duration_unit",
            object_key: "pack_duration",
            type: "select",
            Object_type: "pack_duration",
            placeholder: "Select duration",
            config: {
              dataType: "text",
            },
            options: [
              {
                id: 1,
                value: "W",
                displayValue: "Week",
              },
              {
                id: 2,
                value: "M",
                displayValue: "Month",
              },
              {
                id: 3,
                value: "Y",
                displayValue: "Year",
              },
            ],
            value: "",
            validation: {
              required: true,
            },
            valid: false,
          },
        ],
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_max_allowed_booking",
        displayLabel: "No. of services",
        type: "input",
        min: 0,
        placeholder: "Enter Number",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_price",
        displayLabel: "Package price",
        type: "input",
        min: 0,
        icon: "attach_money",
        placeholder: "Enter package price",
        config: {
          dataType: "number",
        },
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_service_fee",
        object_key: "service_fee",
        displayLabel: "Service fee",
        type: "label",
        config: {
          dataType: "",
        },
        divClass: "",
        multiElement: [
          {
            id: "package_service_fee",
            name: "package_service_fee",
            disableFieldGroup: true,
            object_key: "service_fee",
            Object_type: "service_fee",
            type: "radio",
            placeholder: "Select service type",
            config: {
              dataType: "radio",
            },
            options: [
              {
                id: 1,
                value: "0",
                displayValue: "Free",
              },
              {
                id: 2,
                value: "input",
                displayValue: "Enter Price",
              },
            ],
            value: "",
            validation: {
              required: false,
            },
            valid: false,
          },
          {
            id: "package_service_fee",
            type: "input",
            min: 0,
            Object_type: "service_fee",
            placeholder: "Enter Service Fee",
            config: {
              dataType: "number",
            },
            value: "",
            validation: {
              required: false,
            },
            hidden: true,
            valid: false,
          },
        ],
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
      {
        id: "package_auto_renewed",
        name: "package_auto_renewed",
        displayLabel: "Auto renew",
        type: "radio",
        hidden: false,
        config: {
          dataType: "radio",
        },
        options: [
          {
            id: "package_auto_renewed",
            value: "1",
            displayValue: "Yes",
          },
          {
            id: "package_auto_renewed",
            value: "0",
            displayValue: "No",
          },
        ],
        value: "",
        validation: {
          required: true,
        },
        valid: false,
      },
      {
        id: "package_parking_fee_inclusive",
        object_key: "parking_charge",
        min: 0,
        displayLabel: "Parking",
        defaultValue: true,
        type: "input",
        options: [],
        config: {
          dataType: "number",
        },
        validation: {
          required: false,
        },
        valid: true,
      },
      {
        id: "addons",
        // object_key:"addons",
        displayLabel: "Services",
        type: "label",
        divCustomClass: "fieldGroup",
        config: {
          dataType: "",
        },
        value: "",
        validation: {
          required: false,
        },
        valid: false,
      },
    ],
  },

];

export const HourMapping = {
  D: " day",
  W: " week",
  H: " hr",
  M: " month",
  Y: " year",
};
export const recovery_insurance_category_type="3"

//   export const AddOnsIcon = {
//     "car wash":""
//     ""
//   }
