import { useState } from "react";
import authContext from "./authContext";

const AuthState = (props) => {
  const [auth, setAuth] = useState({
    userId: "",
    userEmail: "",
    isLoggedIn: false,
    accessToken: "",
    userFirstName:"",
    userLastName: "",
    priviliges:[]
  });

  const updateUserAuthDataHandler = (data) => {
    setAuth(data);
  };
  const contextData = {
    auth,
    setAuth: updateUserAuthDataHandler,
  };
  return (
    <authContext.Provider value={contextData}>
      {props.children}
    </authContext.Provider>
  );
};
export default AuthState;
