import { axiosPrivate } from "../api/PrivateRequestServices";
import { useEffect } from "react";
import useRefreshToken from "./useRefreshToken";
import useAuth from "./useAuth";
axiosPrivate.defaults.timeout = 150000;
const useAxiosIntercept = () => {
  const refresh = useRefreshToken();
  const { auth } = useAuth();

  useEffect(() => {
    const requestIntercept = axiosPrivate.interceptors.request.use(
      (config) => {
        if (!config.headers["Authorization"]) {
          config.headers["Authorization"] = `Bearer ${auth?.accessToken}`;
          config.headers["x-user"] = auth?.userId;
        }
        return config;
      },
      (error) => Promise.reject(error)
    );

    const responseIntercept = axiosPrivate.interceptors.response.use(
      (response) => {
        return response;
      },
      async (error) => {
        const prevRequest = error?.config;

        if (error?.response?.status === 404 && !prevRequest?.sent) {
          prevRequest.sent = true;
          const refreshResult = await refresh();
          prevRequest.headers[
            "Authorization"
          ] = `Bearer ${refreshResult?.token}`;
          prevRequest.headers["x-user"] = refreshResult?.user_id;

          return axiosPrivate(prevRequest);
        }
        return Promise.reject(error);
      }
    );

    return () => {
      axiosPrivate.interceptors.request.eject(requestIntercept);
      axiosPrivate.interceptors.response.eject(responseIntercept);
    };
  }, [auth, refresh]);

  return axiosPrivate;
};

export default useAxiosIntercept;
