import { useState, useCallback } from "react";
import useAxiosIntercept from "./useAxiosIntercept";

const useHttp = () => {
  const [isLoading, setIsLoading] = useState(false);
  const axiosPrivate = useAxiosIntercept();
  const sendRequest = useCallback(async (requestConfig, setRequiredData) => {
    setIsLoading(true);
    let response;
    if (requestConfig.request_method == "post") {
      response = await axiosPrivate.post(
        requestConfig.url,
        requestConfig.request_body
      );
    } else {
      response = await axiosPrivate.get(requestConfig.url);
    }

    const data = response;
    setRequiredData(data);
    setIsLoading(false);
  }, []);
  return {
    isLoading,
    sendRequest,
  };
};

export default useHttp;
