import { useNavigate } from "react-router-dom";

import Logout from "../services/Logout";
import useAuth from "./useAuth";

import Cookies from "universal-cookie";

const useLogout = () => {
  // let navigate = useNavigate();

  const { setAuth } = useAuth();
  const cookies = new Cookies();

  const logout = async () => {
    cookies.remove("ulid_D_A");

    setAuth({
      accessToken: "",
      isLoggedIn: false,
    });

    const res = await Logout();

    if (res.response.type === "API_SUCCESS" || res.response.status === 200) {
      // navigate("/login" , {replace:true});

      // window.location.href = "/login";
      window.location.replace("/login");
    }
    return res;
  };
  return logout;
};
export default useLogout;
