import { useCallback, useRef } from "react";
import { useEffect } from "react";

const usePaginate = (isLoading, hasMore, setCurrentPage) => {
  // Pagination Logic
  const observer = useRef();
  //   const handelInfiniteScroll = async () => {
  //     try {
  //       if (
  //         window.innerHeight + document.documentElement.scrollTop + 1 >=
  //         document.documentElement.scrollHeight
  //       ) {
  //         // setLoading(true);
  //         setCurrentPage((prev) => prev + 1);
  //       }
  //     } catch (error) {
  //       console.log(error);
  //     }
  //   };
  //   useEffect(() => {
  //     window.addEventListener("scroll", handelInfiniteScroll);
  //     return () => window.removeEventListener("scroll", handelInfiniteScroll);
  //   }, []);
  const lastElementRef = useCallback(
    (node) => {
      if (isLoading) {
        return;
      }
      if (observer.current) {
        observer.current.disconnect();
      }
      observer.current = new IntersectionObserver((entries) => {
        if (entries[0].isIntersecting && hasMore) {
          setCurrentPage((prev) => {
            return prev + 1;
          });
        }
      });

      if (node) {
        observer.current.observe(node);
      }
    },
    [isLoading, hasMore, setCurrentPage]
  );

  return {
    lastElementRef,
  };
};

export default usePaginate;
