import useAuth from "./useAuth";
import { RefreshToken } from "../services/RefreshToken";
import { Base64 } from "js-base64";
import Cookies from "universal-cookie";

const useRefreshToken = () => {
  const { setAuth } = useAuth();
  const cookies = new Cookies();

  const refresh = async () => {
    const res = await RefreshToken();
    // console.log(`Refresh Token API response - ${JSON.stringify(res)}`);
    if (res.error) {
    } else if (res?.response.type === "API_ERROR") {
      if (res.response.errors instanceof Array) {
        // set error state (whilst pulling message from respective object)
        // console.log("Instance of array...");
      } else {
        // Push directly in array and set error state
        // console.log(`Refresh token Else (else-if)`);
        cookies.remove("ulid_D_A", {path: "/", domain: process.env.REACT_APP_COOKIE_DOMAIN});
        setAuth((prev) => {
          // console.log(`Auth Prev Data`, JSON.stringify(prev));
          return {
            ...prev,
            allowLogin: false,
          };
        });
      }
    } else {
      const { access_token } = res?.response?.data;
      const decryptData = JSON.parse(Base64.decode(access_token));
      setAuth((prev) => {
        return {
          ...prev,
          accessToken: access_token,
          isLoggedIn: true,
          userId: decryptData?.user_id,
        };
      });
      return {
        token: access_token,
        user_id: decryptData?.user_id,
      };
    }
  };
  return refresh;
};

export default useRefreshToken;
