import {
  BrowserRouter as Router,
  Routes,
  Route,
  Navigate,
} from "react-router-dom";

import EditEV from "../components/Views/Settings/EditEV";
import PersistLogin from "../components/Auth/PersistLogin";
import Unauthorized from "../components/Auth/Unauthorized";
import Authorization from "../components/Auth/Authorization";
import UserVerifyOtp from "../components/Auth/UserVerifyOtp";
import Customer from "../components/Views/Customer/Customers";
import PackagesList from "../components/Views/Package/PackagesList";
import CustomerProfile from "../components/Views/Customer/CustomerProfile";
import CreatePackage from "../components/Views/Package/CreatePackage";
import Login from "../components/Views/Login/Login";
import Logout from "../components/Views/Login/Logout";
import Drivers from "../components/Views/Drivers/Drivers";
import Puppy from "../components/Views/Puppy/Puppy";
import Brand from "../components/Views/Brand/Brand";
import BrandModelVariantList from "../components/Views/Brand/BrandModelVariantList";
import useAuth from "../hooks/useAuth";
import CreateCustomer from "../components/Customer/CreateCustomer/CreateCustomer";
import CreateNewCustomer from "../components/Views/Customer/CreateNewCustomer";
import CreateAttendant from "../components/Views/Attendants/CreateAttendant";
import Booking from "../components/Bookings/Booking";
import Settings from "../components/Views/Settings/Settings";
import BrandDetails from "../components/Views/Settings/BrandDetails";
import EditBrand from "../components/Views/Settings/EditBrand";
import ChargingCenters from "../components/Views/ChargingCenters/ChargingCenters";
import ChargingCentersDetails from "../components/Views/ChargingCenters/ChargingCentersDetails";
import AddNewChargingCentre from "../components/Views/ChargingCenters/AddNewChargingCentre";
// import CreatePartnerSteps from "../components/Customer/Partner/CreatePartnerSteps/CreatePartnerSteps";
// import CreateNewPartner from "../components/Views/Customer/Partner/CreateNewPartner";

//import CreateNewBrand from "../components/Views/Brand/CreateNewBrand";
//import Partner from "../components/Views/Customer/Partner/Partner";
import Partner from "../components/Views/Customer/Partner/Partner";
import Cookies from "universal-cookie";
import { Base64 } from "js-base64";
import CreatePartner from "../components/Views/Customer/Partner/CreatePartner";
import Corporate from "../components/Views/Customer/Corporate/Corporate";
import CreateNewCorporate from "../components/Customer/Corporate/CreateCorporate/CreateNewCorporate";
import CreateCorporate from "../components/Views/Customer/Corporate/CreateCorporate";
import Attendants from "../components/Views/Attendants/Attendents";
import ViewBrandDetails from "../components/Settings/Brands/ViewBrandDetails";
import CreateNewBrand from "../components/Views/Settings/CreateNewBrand";
import CreateNewEV from "../components/Views/Settings/CreateNewEV";
import AttendantProfile from "../components/Attendants/AttendantProfile";
import AttendantsDetails from "../components/Views/Attendants/AttendantsDetails";
import CreateNewPuppy from "../components/Puppy/CreatePuppy/CreateNewPuppy";
import CreatePuppy from "../components/Views/Puppy/CreatePuppy";
import BookingSlots from "../components/Views/BookingSlots/BookingSlots";
import Accounts from "../components/Views/Accounts/Accounts";
import PartnerAccountDetails from "../components/Views/Accounts/PartnerAccountDetails";

import EditPartner from "../components/Views/Customer/Partner/EditPartner";
import EditCorporate from "../components/Views/Customer/Corporate/EditCorporate";
import MakeNewBooking from "../components/Bookings/MakeNewBooking";
import DashboardAdmin from "../components/Views/DashboardAdmin/DashboardAdmin";
import CustomerPartnerDetails from "../components/Customer/Partner/CustomerPartnerDetails";
import PartnerDetails from "../components/Views/Customer/Partner/PartnerDetails";
import CorporateDetails from "../components/Views/Customer/Corporate/CorporateDetails";
import ScrollToTop from "./ScrollToTop";
import JobPlanner from "../components/Views/JobPlanner/JobPlanner";
const PupRoutes = () => {
  const { auth } = useAuth();
  const cookies = new Cookies();
  let getKey = false;
  if (cookies.get("ulid_D_A") != undefined) {
    // console.log(`if condition`);
    getKey = true;
  } else {
    getKey = false;
  }

  return (
    <Router>
      <ScrollToTop>
        <Routes>
          <Route
            path="/"
            element={
              getKey ? <Navigate to="/dashboard" /> : <Navigate to="/login" />
            }
          />
          <Route
            path="/login"
            element={getKey ? <Navigate to="/dashboard" /> : <Login />}
          />
          {/* <Route path="/" element={<Dashboard />} />
        <Route path="/login" element={<Login />} /> */}
          <Route path="/logout" element={<Logout />} />
          <Route path="/verify" element={<UserVerifyOtp />} />
          <Route
            path="*"
            element={
              getKey ? <Navigate to="/dashboard" /> : <Navigate to="/login" />
            }
          />
          <Route element={<PersistLogin />}>
            <Route element={<Authorization />}>
              <Route path="/dashboard" element={<DashboardAdmin />} />
              <Route path="/customers/users" element={<Customer />} />
              <Route path="/bookings" element={<Booking />} />
              <Route path="/settings" element={<Settings />} />
              <Route path="/puppy" element={<Puppy />} />
              <Route path="/accounts" element={<Accounts />} />

              <Route
                path="/accounts/accountDetails/:user_id"
                element={<PartnerAccountDetails />}
              />
              <Route
                path="/customers/partner/editPartner/:partner_id"
                element={<EditPartner />}
              />
              <Route
                path="/customers/partner/CustomerPartnerDetails/:partner_id"
                element={<PartnerDetails />}
              />
              <Route
                path="/job_planner"
                element={<JobPlanner />}
              />
              <Route
                path="/customers/corporate/CustomerCorporateDetails/:partner_id"
                element={<CorporateDetails />}
              />
              <Route
                path="/customers/corporate/editCorporate/:partner_id"
                element={<EditCorporate />}
              />
              <Route
                path="/bookings/makeNewBooking"
                element={<MakeNewBooking />}
              />
              <Route path="/customers/partner" element={<Partner />} />
              <Route path="/customers/corporate" element={<Corporate />} />
              <Route
                path="/customers/createNewCustomer"
                element={<CreateNewCustomer />}
              />
              <Route
                path="/customers/users/customerProfile/:user_id"
                element={<CustomerProfile />}
              />
              <Route
                path="/settings/branddetails/:brand_id"
                element={<BrandDetails />}
              ></Route>
              <Route
                path="/attendants/attendantsProfile/:user_id"
                element={<AttendantsDetails />}
              />
              <Route path="/brand" element={<Brand />} />
              <Route
                path="/brand/brandModelVariantList/:id"
                element={<BrandModelVariantList />}
              />
              <Route path="/brand/createNewBrand" element={<CreateNewBrand />} />
              <Route path="/puppy/createNewPuppy" element={<CreatePuppy />} />
              <Route path="/packages" element={<PackagesList />} />
              <Route path="/packages/createPackage" element={<CreatePackage />} />
              <Route
                path="/customers/CreateNewCorporate"
                element={<CreateCorporate />}
              />
              <Route path="/attendants" element={<Attendants />} />
              <Route
                path="customers/CreateNewPartner"
                element={<CreatePartner />}
              />
              <Route path="/createNewAttendant" element={<CreateAttendant />} />
              <Route path="/settings/addnewbrand" element={<CreateNewBrand />} />
              <Route
                path="settings/branddetails/:brand_id/editEV/:variant_id"
                element={<EditEV />}
              />
              <Route
                path="/settings/addnewEV/:brand_id"
                element={<CreateNewEV />}
              />
              <Route path="/booking_slots" element={<BookingSlots />} />
              <Route
                path="/settings/editbrand/:brand_id"
                element={<EditBrand />}
              />
              <Route path="/charging_centers" element={<ChargingCenters />} />
              <Route
                path="/charging_centers/details/:centre_id"
                element={<ChargingCentersDetails />}
              />
              <Route
                path="/addNewChargingCentre"
                element={<AddNewChargingCentre />}
              />
            </Route>
          </Route>
        </Routes>
      </ScrollToTop>
    </Router>
  );
};

export default PupRoutes;
