import { getRequest } from "../api/RequestSevices";
import responseHandler from "./responseHandler";

export const RefreshToken = async () => {
  const URL = process.env.REACT_APP_REFRESH_TOKEN_URL;
  //console.log(`URL: ${URL}`);
  try {
    const { data } = await getRequest(URL);
    if (data?.status === 200) {
      return responseHandler(data, "API_SUCCESS");
    } else {
      // console.log(`API Error: ${JSON.stringify(data)}`);
      return responseHandler(data, "API_ERROR");
    }
  } catch (err) {
    return responseHandler(err, "NETWORK_ERROR");
  }
};
