import { postRequest } from "../api/RequestSevices";
import responseHandler from "./responseHandler";

const UserAuth = async (params) => {
  try {
    const URL = process.env.REACT_APP_LOGIN_URL;
    
    const { data } = await postRequest(URL, params);
    if (data?.status === 200) {
      return responseHandler(data, "API_SUCCESS");
    } else {
      return responseHandler(data, "API_ERROR");
    }
  } catch (err) {
    return responseHandler(err, "NETWORK_ERROR");
  }
};

export default UserAuth;
