import { postRequest } from "../api/RequestSevices";
import responseHandler from "./responseHandler";

const UserOtpVerify = async (params) => {
  const URL = process.env.REACT_APP_VERIFY_LOGIN_OTP;
  try {
    const { data } = await postRequest(URL, params);
    if (data?.status === 200) {
      return responseHandler(data, "API_SUCCESS");
    } else {
      return responseHandler(data, "API_ERROR");
    }
  } catch (err) {
    return responseHandler(err, "NETWORK_ERROR");
  }
};

export default UserOtpVerify;
