const responseHandler = (input, type) => {
  switch (type) {
    case "NETWORK_ERROR":
      return {
        error: {
          type,
          code: input.code,
          message: input.message,
        },
      };
    case "API_ERROR":
      return {
        response: {
          type,
          status: input?.status,
          message: input?.message,
          errors: input?.response?.errors
            ? input.response.errors
            : input?.message,
        },
      };
    case "API_SUCCESS":
      return {
        response: {
          type,
          status: input?.status,
          message: input?.message,
          data: input?.response?.data,
        },
      };
    default:
      return {};
  }
};

export default responseHandler;
