/** @format */

import React, { useEffect, useState } from 'react';
import { Chart as ChartJS, CategoryScale, LinearScale, BarElement, Title, Tooltip, Legend } from 'chart.js';
import { Bar } from 'react-chartjs-2';
ChartJS.register(CategoryScale, LinearScale, BarElement, Title, Tooltip, Legend);
const labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
function BarGraph({ xAxisLabel, data, graphLabel, barGraphType }) {
  const [datum, setDatum] = useState({
    labels: labels,
    datasets: [
      {
        label: graphLabel,
        data: [],
        barThickness: 11,
        borderRadius: 50,
        backgroundColor: 'rgba(16, 164, 165, 0.8)',
      },
    ],
  });
  const options = {
    responsive: true,
    plugins: {
      legend: {
        position: 'top',
      },
      title: {
        display: true,
        // text: 'Chart.js Bar Chart',
      },
    },
    scales: {
      y: {
        grid: {
          display: false,
        },
        ticks: {
          beginAtZero: true,
        },
      },
      x: {
        grid: {
          display: false,
        },
      },
    },
  };
  useEffect(() => {
    if (xAxisLabel && data && xAxisLabel.length != 0 && data.length != 0) {
      if (barGraphType == 'grouped') {
        setDatum({
          labels: xAxisLabel,
          datasets: [
            {
              label: graphLabel[0],
              data: data[0],
              barThickness: 11,
              borderRadius: 50,
              backgroundColor: ' rgb(12, 112, 114)',
            },
            {
              label: graphLabel[1],
              data: data[1],
              barThickness: 11,
              borderRadius: 50,
              backgroundColor: 'rgba(16, 164, 165, 0.8)',
            },
          ],
        });
       
      }
      else {
         setDatum({
           labels: xAxisLabel,
           datasets: [
             {
               label: graphLabel,
               data: data,
               barThickness: 11,
               borderRadius: 50,
               backgroundColor: 'rgba(16, 164, 165, 0.8)',
             },
           ],
         });
      }
    } else {
      setDatum({
        labels: labels,
        datasets: [
          {
            label: graphLabel,
            data: [],
            barThickness: 11,
            borderRadius: 50,
            backgroundColor: 'rgba(16, 164, 165, 0.8)',
          },
        ],
      });
    }
  }, [xAxisLabel, data, graphLabel]);
  return (
    <Bar
      options={options}
      data={datum}
    />
  );
}

export default BarGraph;
