import React from 'react'
import { useState } from 'react';
import { useParams } from 'react-router-dom';
import Overlay from './Overlay'
import { Link } from 'react-router-dom'
import Error from '../components/UI/Error';

import { axiosPrivate } from '../api/PrivateRequestServices';

export default function CancelBooking({ onBackdropClick, setshowpopup, date, user_firstname, user_lastname, vehicle_registration_no,
    driver_firstname, driver_lastname, registration_no, cancellationReason, time, booking_id, removeBooking, index, user_id, bookingstatus,
    puppy_assigned_time, setisbookingCancelled, isCancelled, setisCancelled

}) {

    const params = useParams();
    const [reason_id, setreasonid] = useState();
    const [message, setMessage] = useState();
    const closepopup = () => {
        document.body.classList.remove('hidden');
        setshowpopup(false);
    }
    const handleinput = (e) => {
        setreasonid(e.target.id);


    }
    const cancelBooking = async () => {

        const URL = process.env.REACT_APP_BOOKING_CANCELLATION_URL;
        const body = {
            cancel_reason_id: reason_id,
            booking_id: booking_id,
            customer_user_id: user_id

        }
        const response = await axiosPrivate.post(URL, body);

        if (response?.data?.status == "200") {
            document.body.classList.remove('hidden');
            removeBooking(index);
            setshowpopup(false);
            //setisbookingCancelled(true);
            setisCancelled(!isCancelled)
        }
        else {
            setMessage(response?.data?.message);
        }
    }
    return (

        <Overlay onBackdropClick={onBackdropClick} >
            <div class="model_box_child cancelBookingP" id="cancelBookingP" style={{ width: "400px" }}>
                <div class="ap_heading">
                    <h4>Cancel booking <span class="material-symbols-rounded black close_model" style={{ marginLeft: "auto" }} onClick={closepopup}>close</span></h4>
                </div>
                <div class="contentSection" style={{ paddingTop: "24px" }}>
                    <section class="assignPromoP dForm">
                        <div class="boxT1 fill">
                            <h4><span>{date}</span><i class="elip"></i><span>{time}</span></h4>
                            <p>
                                <i class="material-symbols-rounded mt-m grey">person</i>
                                <span>{user_firstname + " " + user_lastname}</span>
                                <i class="elip"></i>
                                <em>{vehicle_registration_no}</em>
                            </p>
                            <p class="assignName">
                                <i class="material-symbols-rounded mt-m">airport_shuttle</i>
                                {bookingstatus == "N" ? (<>

                                    <em>Puppy will be assigned by {puppy_assigned_time}</em></>) : (<><span>{driver_firstname + " " + driver_lastname}</span>
                                        <i class="elip"></i>
                                        <em>{registration_no}</em></>)}

                            </p>

                        </div>
                        <div class="fieldGroup">
                            <label>Select reason to mark inactive</label>
                            <ul class="yType">
                                {cancellationReason && cancellationReason.length > 0 ? cancellationReason.map((reason) => {
                                    return (
                                        <li>
                                            <input onClick={handleinput} type="radio" id={reason.reason_id} name="radio" value={reason.reason} />
                                            <label for={reason.reason_id}>{reason.reason}</label>
                                        </li>
                                    )

                                }) : ""}

                            </ul>
                        </div>
                    </section>
                    <div class="actionButtons mt-24">
                        <span>
                            <button disabled={message ? "disabled" : ""} class="btn prim btnError fullW" onClick={cancelBooking}>Cancel this booking</button>
                            <Error error={message} />
                            {/* {message && <span style={{ color: "red" }}>{message}</span>} */}



                        </span>
                    </div>
                </div>
            </div>
        </Overlay>


    )
}
