import React, { useState } from "react";
import FieldElement from "../components/UI/FieldElement";
import responseHandler from "../services/responseHandler";
import useAxiosIntercept from "../hooks/useAxiosIntercept";
import { useEffect } from "react";
import Message from "./Message";
import { recovery_insurance_category_type } from "../configuration/createPackageFormConfigs";
const Form = ({ packageForm, extraInfo }) => {
  const [formData, setFormData] = useState({
    fields: packageForm,
    formValid: false,
  });
  const [showMessage, setShowMessage] = useState(false);
  const [message, setMessage] = useState({});
  const [isChecked, setIsChecked] = useState({});
  const [selectedOption, setSelectedOption] = useState({});
  const [isError, setisError] = useState(false);
  const [error, setError] = useState();
  var errors = [];
  const [serviceId,setServiceId]=useState("");
  const [packagePayload, setPackagePayload] = useState({
    package_account_id: extraInfo?.formData?.package_account_type_id,
    package_type_id: extraInfo?.formData?.package_id,
    package_partner_id: extraInfo?.formData?.package_partner_id,
    vehicle_specs: extraInfo?.formData?.vehicle_specs,
  });
  const [isSuccess, setisSuccess] = useState(false);
  const [servicePayload, setServicePayload] = useState([]);
  const axiosPrivate = useAxiosIntercept();

  const resetState = () => {
    setFormData({
      fields: packageForm,
      formValid: false,
    });
  };

  useEffect(() => {
    setFormData((prev) => {
      return { ...prev, fields: packageForm };
    });
  }, [packageForm]);

  const onFieldUpdateHandle = (event, field, index, is_custom_field = false) => {
    setError("");
    let updatedField = { ...field };
    if (event.target.checked === true && updatedField.object_key === "addon") {   
        if(is_custom_field === false) {
            if(updatedField.max_service_allowed !== undefined) {
                delete updatedField.max_service_allowed;
            }
            if(updatedField.service_charge !== undefined) {
                delete updatedField.service_charge;
            }
        }
      setIsChecked((prev) => {
        return { ...prev, [event.target.name]: event.target.checked };
      });
    }
    else if (
      event.target.checked === false &&
      updatedField.object_key === "addon" &&
      updatedField.type === "checkBox"
    ) {
      setIsChecked((prev) => {
        return { ...prev, [event.target.name]: event.target.checked };
      });
      let id = event.target.id.split("");
     
      id = id[id?.length - 1];
      setSelectedOption((prev) => {
        return { ...prev, ["inp" + id]: false };
      });
    }
    if (event.target.value === "input" || event.target.value === "input2") {
        setSelectedOption((prev) => {
            return { ...prev, [event.target.name]: event.target.checked };
        });
    } else if (event.target.checked === true && (event.target?.value === "0" || (updatedField.type == "radio" && event.target.value > 0))) {
        setSelectedOption((prev) => {
            return { ...prev, [event.target.name]: false };
        });
    }

    if (updatedField?.object_key === "addon") {
      if (
        updatedField?.type === "radio"||extraInfo.formData?.package_category_type==recovery_insurance_category_type
        ) {
        let serviceId = updatedField.id.split("_");
        serviceId = serviceId[serviceId?.length - 1];
        setServiceId(serviceId);
        if (updatedField.max_service_allowed !== undefined && updatedField.max_service_allowed != null) {
          setServicePayload((prev) => {
            let prevObjIndex = prev?.findIndex(
              (obj) => obj.service_id === serviceId
            );
            if (prevObjIndex !== -1) {
              let prevObj = [...prev];
              prevObj[prevObjIndex] = {
                ...prevObj[prevObjIndex],
                service_id: serviceId,
                service_required: 1,
                service_charge: updatedField.service_charge,
                service_charge_type: 2,
                service_quantity_type: 2,
                max_service_allowed: updatedField.max_service_allowed,
              };
              return prevObj;
            } else {
              return [
                ...prev,
                {
                  service_id: serviceId,
                  service_required: 1,
                  service_charge: updatedField.service_charge,
                  service_charge_type: 2,
                  service_quantity_type: 2,
                  max_service_allowed: updatedField.max_service_allowed,
                },
              ];
            }
          });
        } else {
          setServicePayload((prev) => {
            let prevObjIndex = prev?.findIndex(
              (obj) => obj.service_id === serviceId
            );
            if (prevObjIndex !== -1) {
              let prevObj = [...prev];
              prevObj[prevObjIndex] = {
                ...prevObj[prevObjIndex],
                service_id: serviceId,
                service_required: 1,
                service_charge: updatedField.service_charge,
                service_quantity_type: 1,
                service_charge_type: 2,
                max_service_allowed: 0,
              };
              return prevObj;
            } else {
              return [
                ...prev,
                {
                  service_id: serviceId,
                  service_required: 1,
                  service_charge: updatedField.service_charge,
                  service_quantity_type: 1,
                  service_charge_type: 2,
                },
              ];
            }
          });
        }
      } else {
        if (event.target?.value === "0" && updatedField?.type === "radio") {
          let serviceId = event.target.name.split("_");
          serviceId = serviceId[serviceId?.length - 1];
          setServicePayload((prev) => {
            let prevObj = prev?.find((obj) => obj.service_id === serviceId);
            if (prevObj) {
              return [
                {
                  ...prevObj,
                  service_id: serviceId,
                  service_required: 1,
                  service_charge: event.target.value,
                  service_charge_type: 2,
                  service_quantity_type: 1,
                  max_service_allowed: event.target.value,
                },
              ];
            } else {
              return [
                ...prev,
                {
                  service_id: serviceId,
                  service_required: 1,
                  service_charge: event.target.value,
                  service_charge_type: 2,
                  service_quantity_type: 1,
                  max_service_allowed: event.target.value,
                },
              ];
            }
          });
        }
      }
    }
    if(is_custom_field === false) {
        updatedField.value = event.target.value;
    }
    updatedField.valid = checkFormValidity(updatedField);

    let updatedFields = [];
    updatedFields = [...formData.fields];
    
    if (
      event.target.checked === false &&
      updatedField.object_key === "addon" &&
      updatedField.type === "checkBox"
    ) { 
        let radioIndex = updatedFields.findIndex(
          (obj) => obj.id == event.target.name
        );
        updatedFields[radioIndex].value = ""; //unset value of addon radio options if addon checkbox is uncheked
        updatedFields = [...formData.fields];  
        let service_id = event.target.name.split("_");
        service_id = service_id[service_id?.length - 1];  
        let service_payload = [...servicePayload];
        let service_index = service_payload.findIndex(
              (obj) => obj.service_id == service_id
            );
        service_payload.splice(service_index, 1); //unset/splice service from servicePayload if addon checkbox is uncheked
        setServicePayload(service_payload);
    }
    if (!updatedField?.Object_type) {
      updatedFields = [...formData.fields];
    } 
    else {
      let multiObj = formData?.fields?.find(
        (obj) => obj.object_key === updatedField?.Object_type
      );
      multiObj?.multiElement.splice(index, 1, updatedField);
      index = formData?.fields?.indexOf(multiObj);
      updatedField = multiObj;
    } // Pulling out only modified node
    updatedFields.splice(index, 1, updatedField);

    /*Calculations Start */
    let calculations = {};
    let calculationIndex = updatedFields.findIndex(
      (obj) => obj.id === "calculation"
    );
    if (
      (calculationIndex != -1 && updatedField.object_key === "package_link") ||
      updatedField.id === "package_price" ||
      updatedField.id === "package_duration"
    ) {
      let package_priceObj = updatedFields.find(
        (obj) => obj.id === "package_price"
      );

      let package_linkObj = updatedFields.find(
        (obj) => obj.object_key === "package_link"
      );
      let package_linkOptionObj = {};
      if (
        package_linkObj?.value !== undefined &&
        package_linkObj?.value !== ""
      ) {
        package_linkOptionObj = package_linkObj.options.find(
          (obj) => obj.id == package_linkObj.value
        );
      }
      let package_durationObj = updatedFields.find(
        (obj) => obj.id == "package_duration"
      );
      if (package_linkOptionObj && package_durationObj) {
        calculations.base_price = package_linkOptionObj.package_price;
        calculations.package_duration =
          package_durationObj.multiElement[0].value;
        calculations.total_price =
          package_linkOptionObj.package_price * calculations.package_duration;
        calculations.partner_price = package_priceObj.value;
        if (calculations.total_price > package_priceObj.value) {
          calculations.discount =
            calculations.total_price - calculations.partner_price;
        } else {
          calculations.discount = 0;
        }
        if (calculationIndex !== -1) {
          updatedFields[calculationIndex].data = calculations;
        }
      }
    }
    /*Calculations Ends */
    
    
    let formValid = true;
    for (let field of updatedFields) {
      if (!field.valid) {
        formValid = false;
      }
    }

    if (field?.object_key && !updatedField?.multiElement) {

      field?.options?.map((option) => {
        {
          option?.value === event.target.value &&
            setPackagePayload((prev) => {
              return {
                ...prev,
                ...option?.data,
                [event.target.name]: event.target.value,
              };
            });
        }
      });
    } else if (event.target.value === "0" && event.target.checked === true) {
      setPackagePayload((prev) => {
        return {
          ...prev,
          [event.target.name]: event.target.value,
        };
      });
    } else {
        if(field?.object_key == "charge_rate" && event.target.value != "input") {
            setPackagePayload((prev) => {
                    return {
                      ...prev,
                      [field?.id]: event.target.value,
                    };
            });
        }
        else {
        setPackagePayload((prev) => {
              return {
                ...prev,
                [event.target.id]: event.target.value,
              };
            });
        }
    }

    if (field?.object_key === "parking_charge") {
      setPackagePayload((prev) => {
        return {
          ...prev,
          ...field?.options?.[0]?.data,
          ...{ [event.target.id]: event.target.value },
        };
      });
    }
    if(event?.target?.id=="package_free_charge_upto"){
      setPackagePayload((prev) => {
        return {
          ...prev,
          ...{ [event.target.id]: event.target.value },
        };
      });

    }
    setFormData({
      fields: updatedFields,
      formValid: formValid,
    });
  };

  const checkFormValidity = (field) => {
    const rules = field.validation;
    const value = field.value;
    let isValid = true;
    if (!rules) {
      return true;
    }

    if (rules.required) {
      isValid = value.trim() !== "" && isValid;
    }

    if (rules.minLength) {
      isValid = value.length >= rules.minLength && isValid;
    }

    if (rules.maxLength) {
      isValid = value.length <= rules.maxLength && isValid;
    }

    return isValid;
  };

  const onSubmit = async (event) => {
      
    event.preventDefault();
    resetState();
    let dataForAPI = {};
    //let errors=[];
    formData.fields.map((field) => {
      if (field?.defaultValue) {
        if (!field?.value && field?.options?.length === 1) {
          dataForAPI = { ...dataForAPI, ...field?.options[0].data };
        }
      }

      if (
        !field?.multiElement &&
        field?.validation?.required &&
        field?.value === ""
      ) {
        errors[field.id] = field?.displayLabel + " is missing";
        setError(errors);
      }

      if (
        field?.object_key == "addon" && field.value == 1
      ) {
        let pattern = /^[0-9/]*$/;
        if ((!pattern.test(field?.max_service_allowed) || !pattern.test(field?.service_charge))&&extraInfo.formData?.package_category_type!=recovery_insurance_category_type) {
          errors[field.id] =
            "Please add correct value of addon (" + field.extra + ")";
          setError(errors);
        }
      }else if (
        field?.object_key == "addon" && field.value == 2
      ) {
      
        let pattern = /^[0-9/]*$/;
        if (!pattern.test(field?.service_charge)&&extraInfo.formData?.package_category_type!=recovery_insurance_category_type) {
          errors[field.id] =
            "Please add correct value of addon (" + field.extra + ")";
          setError(errors);
        }
      }else if(field?.object_key == "addon" && field?.type == "radio" && (field.value == "" || field.value === undefined)&&extraInfo.formData?.package_category_type!=recovery_insurance_category_type) 
      {
            if(isChecked[field.id] === true) {
                errors[field.id] =
                "Please select an option for addon (" + field.extra + ")";
              setError(errors);
            } 
        }

      if (field?.config.dataType === "number") {
        if (field?.value < 0) {
          errors[field.id] =
            "Value must be greater than 0 in " + field?.displayLabel + " field";
          setError(errors);
        }
      }

      if (field?.multiElement) {
        field.multiElement.map((multiEle) => {
          if (multiEle.value < 0) {
            errors[field.id] =
              "Value must be greater than 0 in " +
              field?.displayLabel +
              " field";
            setError(errors);
          }
          if(multiEle?.id=="package_service_fee"&& multiEle?.config?.dataType=="number"){
            if (multiEle.value!=""&&multiEle.value <=0) {
              errors[field.id] =
                "Value must be greater than 0 in " +
                field?.displayLabel +
                " field";
              setError(errors);
            }

          }
          if(multiEle?.id=="package_duration"){
            let pattern = /^[0-9/]*$/;
            if(!pattern.test(multiEle.value)){
              errors[field.id] ="Please enter correct value of "+
              field?.displayLabel 
             ;
            setError(errors);
            }
            
          }
        });
      }

      return dataForAPI;
    });

    if(servicePayload?.length>"0"&&extraInfo.formData?.package_category_type==recovery_insurance_category_type){
      servicePayload.map((service)=>{
        if(service.service_id==process.env.REACT_APP_MOBILE_CHARGING_SERVICE_ID){
          if(!packagePayload?.package_free_charge_upto){
            errors['package_free_charge_upto'] = "Please enter value of free charge upto field";
            setError(errors);

          }
          else{
            if(packagePayload?.package_free_charge_upto<=0){
              errors['package_free_charge_upto'] = "Value must be greater than 0 in  free charge upto field";
              setError(errors);
              
            }

          }

        }

      })
    }
    dataForAPI = {
      ...dataForAPI,
      ...packagePayload,
      service_data: [...servicePayload],
    };

    // API call here...

    try {
      if (Object.keys(errors).length === 0) {
        var response = await axiosPrivate.post(
          process.env.REACT_APP_ADD_PACKAGE,
          dataForAPI
        );
      } else {
        setFormData({
          fields: formData.fields,
          formValid: false,
        });
        setisError(true);
        return;
      }
      if (response?.data?.status === 200) {
        setisSuccess(true);
        setMessage({
          id: 1,
          text: "created successfully",
          name: packagePayload.package_name,
          type: "package",
        });
        setPackagePayload({});
        setServicePayload([]);
        setShowMessage(true);

      } else {
        setFormData({
          fields: formData.fields,
          formValid: false,
        });
        setisSuccess(false);
        setMessage({
          id: 2,
          text: "creation error:" + response?.data?.message,
          name: packagePayload.package_name,
          type: "package",
        });
        setShowMessage(true);
      }
    } catch (err) {
      setFormData({
        fields: formData.fields,
        formValid: false,
      });
      setMessage({
        id: 3,
        text: "creation network error",
        name: packagePayload.package_name,
        type: "package",
      });
      return responseHandler(err, "NETWORK_ERROR");
    }
  };

  const onBackdropClick = () => {
    setShowMessage(false);
  };

  return (
    <>  
      {showMessage && (
        <Message
          message={message}
          onBackdropClick={onBackdropClick}
          isSuccess={isSuccess}
          errorLink="/packages/createPackage"
          successLink="/Packages"
          errorValue="Try again"
          successValue="Go Back To Packages"
          setShowMessage={setShowMessage}
          setFormData={setFormData}
        />
      )}
      <form onSubmit={(event) => onSubmit(event)}>
        {formData.fields.map((field, index) => {
          if (field?.multiElement?.length > 0) {
            return (
              <>
                <div className="fieldGroup">
                  {field?.displayLabel && <FieldElement fieldConfig={field} />}
                </div>
                <div
                  className={field?.divClass ? field?.divClass : ""}
                  style={{ width: "350px" }}
                >
                  {field?.multiElement.map((element, index) => {
                    return (
                      <>
                        <FieldElement
                          fieldConfig={element}
                          changed={(event) =>
                            onFieldUpdateHandle(event, element, index)
                          }
                          isChecked={isChecked}
                          selectedOption={selectedOption}
                          onFieldUpdateHandle={onFieldUpdateHandle}
                          index={index}
                        />
                        {/* {error?.[field.id] !== undefined ? (
                          <div class="alertTxt mt-12">
                            <span class="error">
                              <i class="material-symbols-rounded fill mt-s error mr-4">
                                error
                              </i>
                              {error?.[field.id]}
                            </span>
                          </div>
                        ) : (
                          ""
                        )} */}
                      </>
                    );
                  })}
                </div>
                {error?.[field.id] !== undefined ? (
                          <div class="alertTxt mt-12">
                            <span class="error">
                              <i class="material-symbols-rounded fill mt-s error mr-4">
                                error
                              </i>
                              {error?.[field.id]}
                            </span>
                          </div>
                        ) : (
                          ""
                        )}
              </>
            );
          } else {
            return (
              <>
                <FieldElement
                  fieldConfig={field}
                  changed={(event) => onFieldUpdateHandle(event, field, index)}
                  isChecked={isChecked}
                  selectedOption={selectedOption}
                  onFieldUpdateHandle={onFieldUpdateHandle}
                  index={index}
                  extraInfo={extraInfo}
                  serviceId={serviceId}
                  error={error}
                />
                {error?.[field.id] !== undefined ? (
                  <div class="alertTxt mt-12">
                    <span class="error">
                      <i class="material-symbols-rounded fill mt-s error mr-4">
                        error
                      </i>
                      {error?.[field.id]}
                    </span>
                  </div>
                ) : (
                  ""
                )}
              </>
            );
          }
        })}

        {/* {errors?.[0]?(<>{
        errors.map((err)=>{
          console.log(err)

        })
       }
        
       </>):(<></>)} */}
        {error?.[0] ? (
          error.map((err) => {
            return (
              <>
                <span style={{ color: "red" }}>{err}</span>
                <br />
              </>
            );
          })
        ) : (
          <></>
        )}
        <br></br>
        <button
          type="submit"
          className="btn prim"
          // disabled={!formData.formValid}
        >
          Create new package
        </button>
      </form>
    </>
  );
};

export default Form;
