import React from "react";
import DynamicForm from "./DynamicForm";

const FormMapper = ({
  dynamicFormDatas,
  addOns,
  extraInfo,
  formObject,
  packageLinkData,
}) => {
  const generateDynamicForm = (extraInfo, formObject) => {
    if (dynamicFormDatas?.options?.form_data?.length > 0) {
      dynamicFormDatas?.options?.form_data.map((dynamicFormData) => {
        const packIndex = formObject?.form?.findIndex(
          (obj) => obj.object_key === dynamicFormData.object_key
        );
        if (packIndex >= 0) {
            
         if(formObject.form[packIndex]?.multiElement !== undefined) {
             formObject.form[packIndex].multiElement[0].options = [...dynamicFormData?.values].concat([{
		     id: 3,
		     value: "input",
		     displayValue: "Custom price"
		  }]);
         }else {
                formObject.form[packIndex].options = [...dynamicFormData?.values];
          }
        }
      });
    }

    if (packageLinkData) {
      let index = formObject?.form?.findIndex(
        (item) => item.object_key === "package_link"
      );
      let options = [];
      packageLinkData.map((packageInfo) => {
        let display_value = packageInfo?.package_name;
        if (packageInfo?.maximum_battery_unit == "10000") {
          if (packageInfo?.minimum_battery_unit == 0) {
            display_value += " (All battery type)";
          } else if (packageInfo?.minimum_battery_unit > 0) {
            display_value += " (>" + packageInfo?.minimum_battery_unit + "kWh)";
          }
        }
        else {
          if (packageInfo?.minimum_battery_unit != 0) {
            display_value += " (" + packageInfo?.minimum_battery_unit + "-" + packageInfo?.maximum_battery_unit + "kWh)";
          } else {
            display_value += " (<" + packageInfo?.maximum_battery_unit + "kWh)";
          }
        }
        let option = {
          id: packageInfo?.package_id,
          value: packageInfo?.package_id,
          displayValue: display_value,
          package_price: packageInfo?.package_price
        };
        options.push(option);

      });
      if (index >= 0) {
        formObject.form[index].options = [...options];
      }
    }

    return (
      <>
        {formObject.form.length > 0 ? (
          <DynamicForm packageForm={formObject.form} extraInfo={extraInfo} />
        ) : (
          <p>loading</p>
        )}
      </>
    );
  };
  return generateDynamicForm(extraInfo, formObject);
};

export default FormMapper;
