import React from 'react'
import { useState } from 'react'
import Overlay from './Overlay'
import NoPreview from "../assets/images/noPreview.png"
export default function ImagePopUp({ imageData, setOpenImage, setimageData }) {
    const [currentTab, setCurrentTab] = useState(imageData?.currentTab);
    const [index, setIndex] = useState(imageData?.index)
    const handleTab = (e, index) => {
        setCurrentTab(e.currentTarget.id);
        setIndex(index);
    }
    const handlePreviousSlide = () => {

        if (imageData?.tabs) {
            if (index > 0) {
                setIndex(index - 1)
            }
        }
        else {
            if (imageData?.index > 0) {
                setimageData((prev) => {
                    return {
                        ...prev,
                        index: imageData.index - 1

                    }


                })

            }

        }
    }
    const handleNextSlide = () => {

        if (imageData?.tabs) {

            if (index < imageData?.total - 1) {
                setIndex(index + 1)
            }

        }
        else {
            if (imageData.index < imageData?.total - 1) {
                setimageData((prev) => {
                    return {
                        ...prev,
                        index: imageData.index + 1

                    }


                })
            }

        }
    }
    return (
        <>
            <Overlay>
                <div class={imageData?.outerClass} id={imageData?.outerId} style={{ width: "710px" }}>
                    <div class="ap_heading">
                        {imageData?.tabs ? <h4>{imageData.heading} <b>{parseFloat(index) + 1 + "/" + parseFloat(imageData.total)}</b><span class="material-symbols-rounded black close_model" onClick={() => { setOpenImage(false); document.body.classList.remove("hidden"); }}>close</span></h4> : <h4>{imageData.heading} <b>{parseFloat(imageData.index) + 1 + "/" + parseFloat(imageData.total)}</b><span class="material-symbols-rounded black close_model" onClick={() => { setOpenImage(false); document.body.classList.remove("hidden"); }}>close</span></h4>}

                    </div>

                    {imageData?.type == 'tabs_with_icons' ? (<>
                        <div class="navTabs mt-16 mb-16">
                            <div class="cHistory pad-0">
                                <ul class="level1">
                                    {imageData?.tabs && imageData?.tabs.map((tab, index1) => {
                                        return (<>
                                            <li style={{ cursor: "pointer" }} class={index == index1 ? "selected" : ""} id={tab.id} onClick={(e) => { handleTab(e, index1) }}>
                                                <a >
                                                    <div>
                                                        <i class={tab?.iconclass}>{tab.icon}</i>
                                                        <p>
                                                            <span>{tab?.percentage}</span>
                                                            <span>{tab?.time}</span>
                                                        </p>
                                                    </div>
                                                </a>
                                            </li>
                                        </>)

                                    })}

                                </ul>
                            </div>
                        </div>

                    </>) : imageData?.tabs && <div class="navTabs mt-16">
                        <ul class="level1">
                            {imageData?.tabs && imageData?.tabs.map((tab, index2) => {
                                return (<>
                                    <li style={{ cursor: "pointer" }} class={index == index2 ? "selected" : ""}><a id={tab.id} onClick={(e) => { handleTab(e, index2) }}>{tab.label}</a></li>
                                </>)
                            })}
                        </ul>
                    </div>}

                    <div class="contentSection">

                        <div class="descriptionTxt mb-24">
                            <p>{imageData.findingsdata && imageData.findingsdata[imageData.index].note}</p>
                            <span>{imageData.findingsdata && imageData.findingsdata[imageData.index].time}</span>
                        </div>
                        <div class="photoGallery">
                            <img src={imageData?.tabs ? imageData?.tabs[index]?.image ? imageData?.tabs[index]?.image : NoPreview : imageData.findingsdata ? imageData.findingsdata[imageData.index].image ? imageData.findingsdata[imageData.index].image : NoPreview : imageData?.image ? imageData?.image : NoPreview} alt="" />
                            <div class="cNav">
                                <a className={(imageData?.tabs && index > 0) || (!imageData?.tabs && imageData?.index > 0) ? "prev" : "prev inactive"} title="go previous picture" onClick={handlePreviousSlide} style={{ cursor: "pointer" }}>
                                    <i class="material-symbols-rounded white mt-l">expand_more</i>
                                </a>

                                <a className={(imageData?.tabs && index < parseFloat(imageData?.total) - 1) || (!imageData?.tabs && imageData.index < parseFloat(imageData?.total) - 1) ? "next" : "next inactive"} title="go next picture" onClick={handleNextSlide} style={{ cursor: "pointer" }}>
                                    <i class="material-symbols-rounded white mt-l">expand_less</i>
                                </a>


                            </div>
                        </div>
                    </div>

                </div>

            </Overlay>

        </>
    )
}
