import React from "react";
import { Link } from "react-router-dom";
import Overlay from "./Overlay";

const Message = ({
  message,
  onBackdropClick,
  successLink,
  errorLink,
  successValue,
  errorValue,
  isSuccess,
  setShowMessage,
  doNotNavigate,
  externalLink
}) => {
  const removePopUp = () => {
    document.body.classList.remove('hidden');
    setShowMessage(false);
    if (externalLink) {
      window.open(externalLink, '_blank', 'noreferrer')
    }

  };
  return (
    <Overlay onBackdropClick={onBackdropClick}>
      <div
        className={
          isSuccess
            ? "model_box_child thanksPopup"
            : "model_box_child errorPopup"
        }
        id={isSuccess ? "thanksPopup" : "errorPopup"}
        style={{ width: "320px" }}
      >
        <div className={isSuccess && "successCircle"}>
          <i
            className={
              isSuccess
                ? "material-symbols-rounded white mt-l"
                : "material-symbols-rounded fill"
            }
          >
            {isSuccess ? "done" : "error"}
          </i>
        </div>
        <div className="contentSection">
          <section>
            <div className="text">
              <p>
                {message.name} {message.type}
                <br></br>
                {message.text}
              </p>
            </div>
          </section>
          <div class="actionButtons mt-24">
            <span>
              {doNotNavigate !== undefined || doNotNavigate == true ?
                (<a
                  className="btn prim"
                  onClick={removePopUp}
                >
                  {isSuccess ? successValue : errorValue}
                </a>) :
                (<Link
                  to={isSuccess ? successLink : errorLink}
                  className="btn prim"
                  onClick={removePopUp}

                >
                  {isSuccess ? successValue : errorValue}
                </Link>)
              }
            </span>
          </div>
        </div>
      </div>
      {/* <div style={{position:"relative",left:"30rem",top:"2rem",backgroundColor:"white",width:"300px",height:"100%",padding:".5rem",border:0,borderRadius:"12px",display:"flex",flexDirection:"column"}}>
                <div style={{color:"black",}}>{message.text}</div>
                <button style={{width:"100px",backgroundColor:"gray",color:"white",marginTop:".25rem",height:"100%",padding:".25rem",border:0,borderRadius:"8px",fontWeight:"bold",cursor:"pointer"}} onClick={onBackdropClick}>Go Back</button>
                </div> */}
    </Overlay>
  );
};

export default Message;
