import React from "react";
import { useState } from "react";
import Overlay from "./Overlay";
import useAxiosIntercept from "../hooks/useAxiosIntercept";
import responseHandler from "../services/responseHandler";
import { Link } from "react-router-dom";
const Notification = ({ notifyData, onBackdropClick }) => {

  const axiosPrivate = useAxiosIntercept();
  const [msg, setMsg] = useState("");
  const buttonHandlerNO = () => {
    onBackdropClick();
  };

  const buttonHandlerYes = (e) => {
    const buttonApi = async () => {
      try {
        const response = await axiosPrivate.post(
          notifyData?.url,
          notifyData?.apiRequest
        );


        if (response?.data?.status === 200) {
          onBackdropClick(true, notifyData.id);
        } else {
          if (
            notifyData.error_message !== undefined &&
            notifyData.error_message !== ""
          ) {
            setMsg(notifyData.error_message);
          } else {
            setMsg(response?.data?.response?.errors[0].message);
          }
          //onBackdropClick();
        }
      } catch (err) {
        return responseHandler(err, "NETWORK_ERROR");
      }
    };
    buttonApi();
  };

  return (
    <Overlay onBackdropClick={onBackdropClick} style={{ width: "350px" }}>
      <div className="contentSection">
        <section>
          <div className="text">
            <p>
              {notifyData?.name} {notifyData?.type}
              <br></br>
              {notifyData?.text}
            </p>
          </div>
        </section>
        <div class="actionButtons mt-24">
          <span>
            <Link
              onClick={() => {
                buttonHandlerYes();
              }}
              className="btn prim"
            >
              {" "}
              {notifyData?.buttonNameYes}
            </Link>
            &nbsp;
            <Link onClick={buttonHandlerNO} className="btn prim">
              {" "}
              {notifyData?.buttonNameNo}
            </Link>
          </span>
        </div>
        {msg != "" && (
          <div class="alertTxt mt-8">
            <span class="error">
              <i class="material-symbols-rounded fill mt-s error mr-4">error</i>
              {msg}
            </span>
          </div>
        )}
      </div>
    </Overlay>
  );
};

export default Notification;
