import React from "react";
import { useState } from "react";
import Overlay from "./Overlay";
import useAxiosIntercept from "../hooks/useAxiosIntercept";
import responseHandler from "../services/responseHandler";
import { Link } from "react-router-dom";
import Success from "../components/UI/Success";
import Error from "../components/UI/Error"
const NotificationNew = ({ notifyData, onBackdropClick }) => {
  const axiosPrivate = useAxiosIntercept();
  const [msg, setMsg] = useState("");
  const [enableSubmit,setEnableSubmit]=useState(true);
  const [success, setSuccess] = useState(false);
  const buttonHandlerNO = () => {
    onBackdropClick();
  };

  const buttonHandlerYes = (e) => {
    const buttonApi = async () => {
     
      if(enableSubmit==true)
      {
        setEnableSubmit(false);
        try {
          const response = await axiosPrivate.post(
            notifyData?.url,
            notifyData?.apiRequest
          );
  
          if (response?.data?.status === 200) {
            setEnableSubmit(false);
            notifyData.success && setSuccess(notifyData.success);
            setTimeout(() => {
              onBackdropClick(true, notifyData.id);
  
            }, 3000);
  
          } else {
            setEnableSubmit(true);
            setMsg(response?.data?.response?.errors[0].message);
            //onBackdropClick();
          }
        } catch (err) {
          return responseHandler(err, "NETWORK_ERROR");
        }
      }
    
    };
    buttonApi();
  };

  return (
    <Overlay onBackdropClick={onBackdropClick}>
      <div
        className="model_box_child"
        style={{ width: "350px" }}
      >
        <div class="ap_heading">
          <h4>
            {notifyData.heading && notifyData.heading}
            <span
              onClick={buttonHandlerNO}
              className="material-symbols-rounded black close_model"
            >
              close
            </span>
          </h4>
        </div>
        <div className="contentSection">
          <section>
            <div className="boxT1 fill">
              <h4><span>{notifyData?.name} {notifyData?.type}</span></h4>
              <p>
                <span>{notifyData?.text && notifyData?.text}</span>
              </p>
            </div>
          </section>
          <div className="relative_button_wrap">
            <div class="actionButtons mt-24" style={{ display: "flex" }}>
              <Link
                onClick={() => {
                  buttonHandlerYes();
                }}
                className="btn prim btnError fullWidth"
                style={{ marginRight: "12px" }}
              >
                {" "}
                {notifyData?.buttonNameYes}
              </Link>
              <Link onClick={buttonHandlerNO} className="btn seco fullWidth">
                {" "}
                {notifyData?.buttonNameNo}
              </Link>
            </div>
          </div>
          {/* {msg && <span style={{ color: "red" }}>{msg}</span>} */}
          {msg && <Error error={msg}></Error>}
          {success && <Success success={success} />}
        </div>
      </div>
    </Overlay>
  );
};

export default NotificationNew;
