import React, { Fragment } from "react";
import ReactDOM from "react-dom";
import useOutsideClick from "../hooks/useOutsideClick";

const Backdrop = (props) => {
  document.body.classList.add("hidden");
  return (
    <div id="myModal" className="popup_box open">
      <div className="model_box">{props.children}</div>
    </div>
  );
};

const Modal = (props) => {
  return (
    <div
      style={{
        //   position: "fixed",
        //   zIndex: 30,
        //   top: "20vh",
        //   left: "5%",
        //   width: "90%",

        position: "fixed",
        zIndex: 30,
        top: props.top ? props.top : "20vh",
        left: "35%",
        // position: "absolute",
        // maxHeight: "700px",
        backgroundColor: "white",
        color: "#757575",
        borderRadius: "8px",
        overflowY: "auto",
        padding: "24px",
      }}
      //   className="popup_box model_box"
    >
      {props.children}
      {/* <div className="model_box">{props.children}</div> */}
    </div>
  );
};

const Overlay = (props) => {
  return (
    <Fragment>
      {ReactDOM.createPortal(
        <Backdrop onBackdropClick={props.onBackdropClick}>
          {props.children}
        </Backdrop>,
        document.querySelector("#overlays")
      )}
    </Fragment>
  );
};

export default Overlay;
