import React from "react";
import { Link } from "react-router-dom";
import Overlay from "./Overlay";
import { FormatDate } from "./FormatDate";

const PartnerProfile = ({
  onBackdropClick,
  showPopUP,
  partner_id,
  partner,
}) => {
  if (partner[0].partner_id === partner_id) {
  }

  const closePatnerProfile = () => {
    onBackdropClick();
  };
  return showPopUP ? (
    <>
      {partner.map((partnerData) => {
        if (partnerData?.partner_id === partner_id)
          return (
            <Overlay onBackdropClick={onBackdropClick}>
              <div
                className="model_box_child prd_ns"
                id="contactInfo"
                style={{ width: "420px" }}
              >
                <div className="ap_heading">
                  <h4>
                    Contact info{" "}
                    <span
                      onClick={closePatnerProfile}
                      className="material-symbols-rounded black close_model"
                      style={{ marginLeft: "auto" }}
                    >
                      close
                    </span>
                  </h4>
                </div>
                <div className="contentSection" style={{ paddingTop: "24px" }}>
                  <section className="contactInfoPopup">
                    <div className="head">
                      <p>
                        <img src={partnerData.partner_logo} alt="" />
                      </p>
                      <div className="headindTxt">
                        <p>
                          <span>{partnerData.partner_name}</span>
                        </p>
                        <span className="nextLine subHeading">
                          {`Onboarded on ${FormatDate(
                            partnerData?.created_at
                          )}`}
                        </span>
                      </div>
                    </div>
                    <div className="details">
                      {/* <div>
                        <p>
                          <i className="material-symbols-rounded mt-s grey">
                            person
                          </i>
                          <span>Employee Name</span>
                        </p>
                        <span>
                          {partnerData.employee_name
                            ? partnerData.employee_name
                            : "N/A"}
                        </span>
                      </div> */}
                      {/* <div>
                        <p>
                          <i className="material-symbols-rounded mt-s grey">
                            work
                          </i>
                          <span>Designation</span>
                        </p>
                        <span>
                          {partnerData.designation
                            ? partnerData.designation
                            : "N/A"}
                        </span>
                      </div> */}
                      <div>
                        <p>
                          <i className="material-symbols-rounded mt-s grey">
                            call
                          </i>
                          <span>Phone number</span>
                        </p>
                        <span>{partnerData.phone}</span>
                      </div>
                      <div>
                        <p>
                          <i className="material-symbols-rounded mt-s grey">
                            mail
                          </i>
                          <span>Email ID</span>
                        </p>
                        <span>
                          {partnerData.email ? partnerData.email : "N/A"}
                        </span>
                      </div>
                      {/* <div>
                        <p>
                          <i className="material-symbols-rounded mt-s grey">
                            location_on
                          </i>
                          <span>Address</span>
                        </p>
                        <span>
                          {partnerData.address ? partnerData.address : "N/A"}
                        </span>
                      </div> */}
                    </div>
                  </section>
                </div>
              </div>
            </Overlay>
          );
      })}
    </>
  ) : (
    <></>
  );
};

export default PartnerProfile;
