import React from 'react'
import { Time } from './Time'
import SidePopUp from './SidePopUp'
import { chargingStatusClasses } from '../components/Package/addonsStatusConfig'
import { chargingStatusTag } from '../components/Package/addonsStatusConfig'
export default function ViewChargeHistory({ onBackdropClick, vehicle_registration_no, package_name, vehicle_brand, vehicle_model, variant_image, activityLog, setOpenImage, openImage, imageData, setimageData }) {
    return (
        <>
            <SidePopUp onBackdropClick={onBackdropClick}>
                <div class="model_box_child cHistoryP" id="cHistoryP" style={{ width: "392px" }}>
                    <div class="fixHead" style={{ borderBottom: "#eee solid 1px", display: "flex", zIndex: "2", padding: "8px 12px", height: "64px", width: "webkit-fill-available", marginRight: "8px", paddingLeft: "24px" }}>

                        <h4>
                            <span class="material-symbols-rounded black close_model lPosition" style={{ marginRight: "8px" }} onClick={onBackdropClick}>close</span> View charge history
                        </h4>
                    </div>
                    <div class="contentSection" style={{ paddingTop: "24px" }}>
                        <section>
                            <div class="cVehicleInfo">
                                <div class="vPackage">
                                    <p>
                                        {vehicle_registration_no}
                                        <span>{package_name}</span>
                                    </p>
                                    <p class="vName">{vehicle_brand}-{vehicle_model}</p>
                                </div>
                                <div class="vImg">
                                    <img src={variant_image} alt="" />
                                </div>
                            </div>
                        </section>
                        <section>
                            <div class="cHistory">
                                {activityLog && activityLog?.length != "0" ? (<>
                                    {activityLog.map((history, index1) => {


                                        return (
                                            <div>
                                                <i class={chargingStatusClasses[history.service_status]}>{chargingStatusTag[history.service_status]}</i>
                                                <p>
                                                    <span>{history.service_note + "%"}</span>
                                                    <span>{Time(history.created_on)}</span>
                                                </p>
                                                {history.service_image && <div class="imgPick">
                                                    <img src={history.service_image} alt="" onClick={() => {
                                                        const temp = activityLog?.map((activity, index2) => {
                                                            return {
                                                                id: index2,
                                                                icon: chargingStatusTag[activity.service_status],
                                                                iconclass: chargingStatusClasses[activity.service_status],
                                                                percentage: activity.service_note + "%",
                                                                time: Time(activity.created_on),
                                                                image: activity.service_image

                                                            }
                                                        });
                                                        setOpenImage(true);
                                                        onBackdropClick();
                                                        setimageData({
                                                            heading: "Charge history photos",
                                                            subheading: "",
                                                            time: "",
                                                            tabs: temp,
                                                            currentTab: index1,
                                                            index: index1,
                                                            type: "tabs_with_icons",
                                                            outerClass: "model_box_child cHistoryP cHistoryGalleryP",
                                                            total: activityLog?.length,
                                                            outerId: "cHistoryGalleryP"
                                                        })
                                                    }} />
                                                </div>}

                                            </div>
                                        )

                                    })}




                                </>) : <div>No Data Found</div>}

                            </div>
                        </section>
                    </div>
                </div>

            </SidePopUp>
        </>
    )
}
