<?php

namespace clues\model\pgw;

use clues\system\DI;
use clues\system\BasePlatform;

/**
 * This class is used to perform all operations related to card token maintainance by 2c2p
 * @class CardMaintainance2C2P
 * @access public
 * @package model/pgw
 * @category pgw
 */
class CardMaintainance2C2P extends BasePlatform {

    /**
     * This method is used to add card details
     * @method addCardDetails
     * @access public
     * @param array $cardDetails
     * @return array
     */
    public function addCardDetails($cardDetails) {
        DI::Map('PaymentService', 'clues\\model\\pgw\\PaymentService');
        $paymentServiceObj = DI::Singleton('PaymentService');
        $paymentInfo = $paymentServiceObj->getPaymentInfo($cardDetails['payment_id']);
        $cardDetailsArr = array(
            'version' => $paymentInfo['params']['cardTokenApiVersion'],
            'timeStamp' => date('dmyHis'),
            'merchantID' => $paymentInfo['params']['merchantID'],
            'panCurrency' => $paymentInfo['params']['panCurrency'],
            'panCountry' => $paymentInfo['params']['panCountry'],
            'pan' => $cardDetails['card_no'],
            'cardholderName' => (isset($cardDetails['card_nickname']) && !empty($cardDetails['card_nickname'])) ? $cardDetails['card_nickname'] : 'User',
            'panExpiry' => $cardDetails['expiry_month'] . substr($cardDetails['expiry_year'], -2),
            'action' => $paymentInfo['params']['addCardTokenAction']
        );
        $cardAddArr = array(
            'card_details' => $cardDetailsArr, 
            'card_management_2c2p_url' => $paymentInfo['params']['cardManagement2c2pUrl'],
            'testMode' => $paymentInfo['params']['testMode']
        );
        $url = $paymentInfo['params']['internalSaveCardUrl'];
        $result = $this->_getCurlResponse($url, $cardAddArr);
        $result = json_decode($result, true);
        return $result;
    }

    /**
     * This method is used to delete card
     * @method deleteCard
     * @access public
     * @param string $cardToken
     * @param integer paymentId
     * @return array
     */
    public function deleteCard($cardToken, $paymentId) {
        DI::Map('PaymentService', 'clues\\model\\pgw\\PaymentService');
        $paymentServiceObj = DI::Singleton('PaymentService');
        $paymentInfo = $paymentServiceObj->getPaymentInfo($paymentId);
        $cardDetailsArr = array(
            'version' => $paymentInfo['params']['cardTokenApiVersion'],
            'timeStamp' => date('dmyHis'),
            'merchantID' => $paymentInfo['params']['merchantID'],
            'storeCardUniqueID' => $cardToken,
            'action' => $paymentInfo['params']['deleteCardTokenAction']
        );
        $cardAddArr = array(
            'card_details' => $cardDetailsArr, 
            'card_management_2c2p_url' => $paymentInfo['params']['cardManagement2c2pUrl'],
            'testMode' => $paymentInfo['params']['testMode']
        );
        $url = $paymentInfo['params']['internalSaveCardUrl'];
        $result = $this->_getCurlResponse($url, $cardAddArr);
        $result = json_decode($result, true);
        return $result;
    }

    /**
     * This method is used to get response data
     * @method _getCurlResponse
     * @param string $url 
     * @param array $params 
     * @param array $header
     * @access private
     * @return array $responseArray
     */
    private function _getCurlResponse($url, $params, array $header = array()) {
        $headerArray = array_merge(array('Content-Type: text/plain'), $header);
        if (is_array($params)) {
            $paramsString = json_encode($params);
        } else {
            $paramsString = $params;
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $paramsString);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        return $response;
        $responseArray = isset($response) && !empty($response) ? json_decode($response, true) : array();
        return $responseArray;
    }
}