<?php

namespace clues\model\pgw;

use clues\system\DI;
use clues\system\BasePlatform;

/**
 * This class is used to perform all operations related to payment and pgw mapping
 * @class PaymentPgwMapping
 * @access public
 * @package model/pgw
 * @category pgw
 */
class PaymentPgwMapping extends BasePlatform {

    /**
     * paymentService
     * @var object 
     */
    private $_PaymentServiceObj;

    /**
     * Class constructor
     * @method __construct
     * @access public
     * @return void
     */
    public function __construct($data = array()) {
        parent::__construct();
        DI::Map('PaymentService', 'clues\\model\\pgw\\PaymentService');
        $this->_PaymentServiceObj = DI::Singleton('PaymentService');
    }

    /**
     * This method is used to set the pgw order id
     * @method addPgwOrderId
     * @access public
     * @param object $pgwObject 
     * @param array $additionalData
     * @return void
     */
    public function addPgwOrderId($pgwObject = null, array $additionalData = array()) {
        $pgwOrderifPresent = $this->_checkPgwOrderId($additionalData);
        if (empty($pgwOrderifPresent)) {
            $PGWOrderId = $pgwObject->getPgwOrderId(false);
        } else {
            $PGWOrderId = $pgwObject->getPgwOrderId(true);
        }
        $additionalPgwData = $pgwObject->getPgwMappingPreAdditionalData();
        $this->_insertPaymentPgwMapping($additionalPgwData);
    }

    /**
     * This method is used to insert pgw id
     * @method _insertPaymentPgwMapping
     * @access private 
     * @param array $pgwData
     * @return integer primary key
     */
    private function _insertPaymentPgwMapping($pgwData) {
        return $this->_PaymentServiceObj->insertPgwOrderMapping($pgwData);
    }

    /**
     * This method is used to check the entry of pgw order id
     * @method _checkPgwOrderId
     * @access private 
     * @param array $additionalData
     * @return integer order id
     */
    private function _checkPgwOrderId($additionalData) {
        return $this->_PaymentServiceObj->checkPgwOrderMapping($additionalData);
    }

    /**
     * This method is used to update order pgw id
     * @method updateOrderPgwPrimaryKeyByPgwOrderId
     * @access public 
     * @param integer $orderPgwPrimaryId
     * @param integer $pgwOrderId
     * @param integer $userId
     * @param integer $paymentId payment id
     * @return mixed
     */
    public function updateOrderPgwPrimaryKeyByPgwOrderId($orderPgwPrimaryId, $pgwOrderId, $userId, $paymentId) {
        return $this->_PaymentServiceObj->updateOrderPgwPrimaryKeyByPgwOrderId($orderPgwPrimaryId, $pgwOrderId, $userId, $paymentId);
    }

    /**
     * This method is used to get sc order id
     * @method getScOrderIdByPgwOrderId
     * @access public 
     * @param integer $pgwOrderId
     * @param $paymentId
     * @return integer order id
     */
    public function getScOrderIdByPgwOrderId($pgwOrderId, $paymentId = 0) {
        return $this->_PaymentServiceObj->getScOrderIdByPgwOrderId($pgwOrderId, $paymentId);
    }

    /**
     * This method is used to update prepayment id
     * @method updatePrepaymentPrimaryKeyByPgwOrderId
     * @access public 
     * @param integer $prepaymentPrimaryId
     * @param integer $pgwOrderId
     * @param integer $userId
     * @param integer $orderId
     * @return mixed
     */
    public function updatePrepaymentPrimaryKeyByPgwOrderId($prepaymentPrimaryId, $pgwOrderId, $userId, $orderId = 0) {
        return $this->_PaymentServiceObj->updatePrepaymentPrimaryKeyByPgwOrderId($prepaymentPrimaryId, $pgwOrderId, $userId, $orderId);
    }

}
