<?php

namespace clues\model\pgw;

/**
 * Interface for Pgw model constants
 * 
 * @interface PgwModelConstants
 * @category model interface
 * @package model/cluesBuck
 * @note remove useless constants
 */
interface PgwModelConstants {

    /**
     * pgw paidstatus
     * @var constants
     */
    CONST PAID_STATUS = 'P';

    /**
     * pgw failedstatus
     * @var constants
     */
    CONST FAILED_STATUS = 'F';

    /**
     * pgw domain name
     * @var constants
     */
    const DOMAIN_NAME = 'payment';

    /**
     * initiate payment module name
     * @var constants
     */
    const INITIATE_PAYMENT_MODULE_NAME = 'INITIATE_PAYMENT';

    /**
     * pgw model name
     * @var constants
     */
    const MODULE_NAME = 'pgw';

    /**
     * Payment db config module name
     * @var constant
     */
    CONST PAYMENT_DB_CONFIG_MODULE_NAME = 'payment';

    /**
     * Order info extended type
     * @var constant
     */
    CONST ORDER_INFO_EXTENDED = 'extended';

    /**
     * payment failed status
     * @var constant 
     */
    CONST PAYMENT_FAILED_STATUS = 'F';

    /**
     * payment paid status
     * @var constant 
     */
    CONST PAYMENT_PAID_STATUS = 'P';

    /**
     * notify response key
     * @var constant
     */
    CONST PGW_NOTIFY_RESPONSE_KEY = 'notify_response';

    /**
     * notify response key
     * @var constant
     */
    CONST PAYMENT_RESPONSE_KEY = 'payment_response';

    /**
     * notify response status key
     * @var constant
     */
    CONST PGW_NOTIFY_STATUS_KEY = 'notify_response_status';

    /**
     * payment user id
     * @var constant 
     */
    CONST PAYMENT_USER_ID = 38199908;

    /**
     * payment status key
     * @var constant
     */
    CONST PAYMENT_STATUS_KEY = 'payment_status';

    /**
     * old prepayment id key
     * @var constant
     */
    CONST OLD_PREPAYMENT_ID_KEY = 'old_prepayment_id';

    /**
     * pgw notify module name
     * @var constant
     */
    CONST NOTIFY_MODULE_NAME = 'pgw_notify_api';

    /**
     * notify api picked status
     * @var constant
     */
    CONST NOTIFY_PICKED_STATUS = 4;

    /**
     * notify api updated status
     * @var constant
     */
    CONST NOTIFY_UPDATED_STATUS = 5;

    /**
     * Process time output status
     * @var constant
     */
    CONST PROCESS_TIME_OUTPUT_STATUS = 200;

    /**
     * API domain name
     * @var constant
     */
    CONST DOMAIN_NAME_API = 'Api';

    /**
     * Module name api debugging
     * @var constant
     */
    CONST MODULE_NAME_API_DEBUGGING = 'ApiDebugging';

    /**
     * Save response from pgw method name
     * @var constant
     */
    CONST SAVE_RESPONSE_FROM_PGW_METHOD_NAME = 'saveResponseFromPGW';

    /**
     * Initiate payment method name
     * @var constant
     */
    CONST INITIATE_PAYMENT_METHOD_NAME = 'initiatePayment';

    /**
     * Shopclue default client id
     * @var constant
     */
    CONST DEFAULT_CLIENT_ID = 'pup_default_client_id';

    /**
     * MOMOE CC payment option id
     * @var string const
     */
    const MOMOE_CC_PAYMENT_OPTION_ID = 162;

    /**
     * MOMOE DC payment option id
     * @var string const
     */
    const MOMOE_DC_PAYMENT_OPTION_ID = 163;

    /**
     * token exception status
     * @var constant
     */
    CONST TOKEN_EXCEPTION_STATUS = 2;

    /**
     * key for prepayment data that tells obf card number
     * @var constant
     */
    CONST CARD_NUMBER = 'card_number';

    /**
     * collect zero payment pgw name (virtual)
     * @var constant
     */
    CONST COLLECT_ZERO_PAYMENT_PGW = 'zero_payment';

    /**
     * Context for pgw resquest
     * @var constant
     */
    CONST CONTEXT_PGW_REQUEST = 'pgw_request';

    /**
     * constant for client ip for pgw redirection
     * @var constant
     */
    CONST CLIENT_IP_FOR_SEND_TO_PGW = 'client_ip_for_pgw_redirection';

    /**
     * constant for current prepayment id
     * @var constant
     */
    CONST REGISTRY_PREPAYMENT_ID = 'current_prepayment_id';

    /**
     * constant for savePgwResponse ip addesss
     * @var constant
     */
    CONST PGW_RESPONSE_IP_ADDRESS = 'pgw_response_ip_address';

    /**
     * constant for payment successful status
     * @var constant
     */
    CONST PAYMENT_SUCCESS_STATUS = 1;

    /**
     * constant for payment mark success
     * @var constant
     */
    CONST PAYMENT_MARKED_SUCCESSFUL = 'payment_mark_success';

    /**
     * constant for 2C2P pgw name
     * @var constant 
     */
    CONST Pgw2C2P = '2C2P';

    /**
     * constant for 2C2P notify name
     * @var constant 
     */
    CONST NOTIFY_NAME_2C2P = 'Pgw2C2P';

    /**
     * constant for 2C2P pgw payment id
     * @var constant 
     */
    CONST Pgw2C2P_PAYMENT_ID = 1;

    /**
     * constant for 2C2P pgw payment token success code
     * @var constant 
     */
    CONST Pgw2C2P_PAYMENT_TOKEN_SUCCESS_CODE = '0000';

    /**
     * constant for 2C2P pgw payment token key
     * @var constant 
     */
    CONST Pgw2C2P_PAYMENT_TOKEN_API = '2c2p_payment_token_api';

    /**
     * constant for 2C2P pgw payment key
     * @var constant 
     */
    CONST Pgw2C2P_PAYMENT_API = '2c2p_payment_api';

    /**
     * constant for get order info registry key
     * @var constant 
     */
    CONST REGISTRY_KEY_GET_ORDER_INFO = '_get_order_info';
    
    /**
     * UDF keys
     */
    const CLIENT_UDF_KEYS = ['udf1', 'udf2', 'udf3', 'udf4', 'udf5'];

    /**
     * Admin user id
     * @var constant
     */
    CONST ADMIN_USER_ID = 2;

     /**
     * constant for notify data keys to client
     * @var constant 
     */
    CONST NOTIFY_DATA_KEYS = ['order_id', 'payment_id', 'payment_option_id', 'emi_id', 'emi_name', 'payment_type_id', 'pgw_type', 'pgw', 'pgw_option_name', 'payment_status', 'udf_payment_type', 'pgw_txn_id', 'card_number', 'pgw_order_id', 'client_order_id', 'prepayment_details_auto_increment_id', 'status', 'created_timestamp', 'created', 'updated', 'updated_by', 'created_by', 'payment_received_amt', 'direcpayreferenceid', 'flag', 'payment_status_info'];

    /**
     * constant for atom redirect source
     * @var constant 
     */
    CONST ATOM_REDIRECT_SOURCE = 2;

    /**
     * constant for atom notify source
     * @var constant 
     */
    CONST ATOM_NOTIFY_SOURCE = 3;

    /**
     * constant for pgw reference no
     * @var constant 
     */
    CONST PGW_REF_NO = 'referenceNo';

    /**
     * constant for pgw approval code
     * @var constant 
     */
    CONST PGW_APPROVAL_CODE = 'approvalCode';

    /**
     * constant for pgw direct verify
     * @var constant 
     */
    CONST PGW_DIRECT_VERIFY = 'pgw_direct_verify';

    /**
     * key for prepayment data that tells card type of txn
     * @var constant
     */
    CONST PG_CARD_TYPE = 'pg_card_type';

    /**
     * key for prepayment data that tells card token after tokenisation
     * @var constant
     */
    CONST PG_CARD_TOKEN = 'card_token';

    /**
     * constant for codes to throw exception for initiate payment api
     * @var constant 
     */
    CONST INITIATE_PAYMENT_THROW_EXCEPTION_CODES = ['10011', '10012'];

    /**
     * constant for card token required payment type ids
     * @var constant 
     */
    CONST CARD_TOKEN_REQUIRED_PAYMENT_TYPE_IDS = [1];

    /**
     * const for user card info table
     * @var constant
     */
    const USER_CARD_INFO_TABLE = 'pup_user_card_info';

    /**
     * const for user card info history table
     * @var constant
     */
    const USER_CARD_INFO_HISTORY_TABLE = 'pup_user_card_info_history';
}