<?php

namespace clues\model\pgw\exception;

use clues\system\exception\Status;

class PgwStatus extends Status {

    /**
     * exception in send to pgw 
     * @var constant
     */
    const ECOD_ERROR_IN_SEND_TO_PGW = 7006;

    /**
     * exception Empty clues pgw
     * @var constant
     */
    const EMPTY_CLUES_PGW = 7009;

    /**
     * Empty Order id 
     * @var constant
     */
    const EMPTY_ORDER_ID = 7008;

    /**
     * Send pgw Request
     * @var constant
     */
    const SEND_PGW_REQUEST = 7007;

    /**
     * Sc user id not found
     * @var constant
     */
    const SC_USER_ID_NOT_FOUND = 7008;

    /**
     * PGW parameter missing
     * @var constant
     */
    const PGW_PARAMTER_MISSING = 10001;

    /**
     * invalid payment option id
     * @var constant
     */
    const INVALID_PAYMENT_OPTION_ID = 10012;

    /**
     * constant for ERROR_PAYMENT_STATUS_CHANGE  pgw name
     * @var constant 
     */
    CONST ERROR_PAYMENT_STATUS_CHANGE = 5002;

    /**
     * Order id missing
     * @var constant
     */
    CONST ORDER_ID_MISSING = 10002;

    /**
     * payment option id missing
     * @var constant
     */
    const PAYMENT_OPTION_ID_MISSING = 10003;

    /**
     * total key missing
     * @var constant
     */
    const TOTAL_KEY_MISSING = 10004;

    /**
     * user details missing
     * @var constant
     */
    const USER_DETAILS_MISSING = 10005;

    /**
     * user id missing
     * @var constant
     */
    const USER_ID_MISSING = 10006;

    /**
     * user name missing
     * @var constant
     */
    const USER_NAME_MISSING = 10007;

    /**
     * user email missing
     * @var constant
     */
    const USER_EMAIL_MISSING = 10008;

    /**
     * user mobile missing
     * @var constant
     */
    const USER_MOBILE_MISSING = 10009;

    /**
     * card details missing
     * @var constant
     */
    const CARD_DETAILS_MISSING = 10010;

    /**
     * invalid token/card expired
     * @var constant
     */
    const INVALID_TOKEN_OR_CARD_EXPIRED = 10011;

    /**
     * empty payment token from pgw
     * @var constant
     */
    const EMPTY_PAYMENT_TOKEN_FROM_PGW = 10013;

    /**
     * payment token pgw api error
     * @var constant
     */
    const PAYMENT_TOKEN_API_ERROR = 10014;

    /**
     * payment pgw api error
     * @var constant
     */
    const PAYMENT_API_ERROR = 10015;

    /**
     * invalid/blank order id error
     * @var constant
     */
    const INVALID_OR_BLANK_ORDER_ID = 10016;

    /**
     * exception codes
     * @var array
     */
    public static $codes = array(
        self::ECOD_ERROR_IN_SEND_TO_PGW,
        self::SEND_PGW_REQUEST,
        self::EMPTY_CLUES_PGW,
        self::EMPTY_ORDER_ID,
        self::SC_USER_ID_NOT_FOUND,
        self::PGW_PARAMTER_MISSING,
        self::INVALID_PAYMENT_OPTION_ID,
        self::ERROR_PAYMENT_STATUS_CHANGE,
        self::ORDER_ID_MISSING,
        self::PAYMENT_OPTION_ID_MISSING,
        self::TOTAL_KEY_MISSING,
        self::USER_DETAILS_MISSING,
        self::USER_ID_MISSING,
        self::USER_NAME_MISSING,
        self::USER_EMAIL_MISSING,
        self::USER_MOBILE_MISSING,
        self::CARD_DETAILS_MISSING,
        self::INVALID_TOKEN_OR_CARD_EXPIRED,
        self::EMPTY_PAYMENT_TOKEN_FROM_PGW,
        self::PAYMENT_TOKEN_API_ERROR,
        self::PAYMENT_API_ERROR,
        self::INVALID_OR_BLANK_ORDER_ID
    );

}
