<?php

namespace clues\model\pgwVerify;

use clues\model\pgwVerify\PgwVerifyConstants;

/**
 * Interface for Pgw notify constants
 * @interface PgwVerifyConstants
 * @category model interface
 * @package model/pgwVerify
 */
interface PgwNotifyConstants extends PgwVerifyConstants {

    /**
     * constants for notify status
     * @var constant
     */
    CONST NOTIFY_STATUSES = [
        'delete' => 0,
        'active' => 1,
        'processing' => 2,
        'partially_processed' => 3,
        'no_processing_required' => 4,
        'processed' => 5,
    ];

    /**
     * Notify max retry count
     * @var constant
     */
    CONST MAX_NOTIFY_RETRY_COUNT = 3;

    /**
     * Notify max days for data picking
     * @var constant
     */
    CONST MAX_NOTIFY_DATA_PICK_DAYS = 7;

    /**
     * Notify max limit for data picking
     * @var constant
     */
    CONST MAX_NOTIFY_DATA_LIMIT = 500;

    /**
     * Notify client data payload key
     * @var constant
     */
    CONST NOTIFY_CLIENT_PAYLOAD_KEY = 'payload';

}
