<?php

namespace clues\model\pgwVerify;

use clues\model\pgwVerify\PgwVerifyDBOperations;
use clues\model\pgwVerify\PgwNotifyConstants;

/**
 * This class is used for all payment verify db CRUD operations
 * @class PgwNotifyDBOperations
 * @category Model datasource
 * @package model/pgwVerify
 * @access public
 * @dependencies DBOperations
 */
class PgwNotifyDBOperations extends PgwVerifyDBOperations {

    /**
     * Get Pending orders to notify clients
     * @method getClientNotifyData
     * @access public
     * @param integer $orderId order id 
     * @param integer $daysBefore daysBefore
     * @param integer $retryCount max retry count
     * @return array
     */
    public function getClientNotifyData($orderId = 0, $daysBefore = PgwNotifyConstants::MAX_NOTIFY_DATA_PICK_DAYS, $limit = PgwNotifyConstants::MAX_NOTIFY_DATA_LIMIT, $retryCount = PgwNotifyConstants::MAX_NOTIFY_RETRY_COUNT) {
        $sql = "SELECT 
                n.id,
                n.client_order_id,
                n.notify_data,
                n.created,
                n.updated,
                n.retry_count,
                n.ppm_id,
                ppm.client_id
            FROM
                pup_pgw_notify_mapping AS n
                    INNER JOIN
                pup_payment_pgw_mapping AS ppm ON n.ppm_id = ppm.id
            WHERE
                n.status IN (1 , 3) and n.notify_data !='' and n.notify_data is not null
        AND IF(n.status = 1, n.retry_count = 0, 1)
        AND IF(n.status = 3, n.retry_count > 0 and n.retry_count<=?i, 1)
        AND n.created > date_sub(now(), interval ?i day)";
        $sql = $this->dbQuote($sql, $retryCount, $daysBefore);
        if (!empty($orderId)) {
            $sql .= ' AND n.client_order_id = ?s';
            $sql = $this->dbQuote($sql, $orderId);
        }
        $sql .= $this->dbQuote(' order by n.id asc limit ?i;', $limit);
        return $this->dbGetArray($sql, array(), self::MASTER_NOCACHE);
    }

    /**
     * this method is used update status of notify mapp
     * @method updateClientNotifyStatus
     * @access public
     * @param integer $id notify id
     * @param integer $status
     * @param boolean $updateRetryFlag
     * @return integer
     */
    public function updateClientNotifyStatus($id, $status = 1, $updateRetryFlag = false) {
        $sql = 'update pup_pgw_notify_mapping set status=?i , updated_by=?i,updated=?s ?p where id=?i;';
        $retry = '';
        if ($updateRetryFlag) {
            $retry = $this->dbQuote(', retry_count=retry_count+1 ');
        }
        $sql = $this->dbQuote($sql, $status, PgwNotifyConstants::ADMIN_USER_ID, date('Y-m-d H:i:s'), $retry, $id);
        return $this->dbQueryUpdate($sql);
    }

    /**
     * This method is used to insert data in pup_pgw_notify_mapping_request_response
     * @method insertNotifyReqRes
     * @access public
     * @param array $orderDetails
     * @return integer
     */
    public function insertNotifyReqRes(array $orderDetails) {
        $sql = 'INSERT INTO pup_pgw_notify_mapping_request_response (client_order_id, notify_id, status, created, created_by, retry_count, request_response) VALUES (?s, ?i, ?i, ?s, ?i, ?i, ?s)';
        $sql = $this->dbQuote($sql, $orderDetails['client_order_id'], $orderDetails['notify_id'], $orderDetails['status'], $orderDetails['created'], $orderDetails['created_by'], $orderDetails['retry_count'], $orderDetails['log']);
        return $this->dbQueryInsert($sql);
    }

}
