<?php

namespace clues\model\payment;

/* Please do not include any abstract methods in this interface */

/**
 * This interface is used for all payment constants
 * @interface PaymentConstants
 * @category Model Interface
 * @package model/payment
 * @since 22-Nov-2016
 */
interface PaymentConstants {

    /**
     * Module name
     * @var constant
     */
    const MODULE_NAME = "paymentUrl";

    /**
     * Domain name
     * @var constant
     */
    const DOMAIN_NAME = "payment";

    /**
     * generation event name
     * @var constant
     */
    const ECOD_NAME = 'ECOD';

    /**
     * Order failed data module name
     * @var constant
     */
    const ORDER_FAILED_DATA_MODULE_NAME = 'order_failed_data';

    /**
     * pgwmodel form name 
     * @var constants
     */
    CONST COD_PAYMENT_TYPE = '4';

    /**
     * DEBIT_AGAINIST_PAYOUT_PAYMENT_TYPE
     * @var constants
     */
    CONST DEBIT_AGAINIST_PAYOUT_PAYMENT_TYPE = 17;

    /**
     * pgwmodel form name 
     * @var constants
     */
    CONST EMI_PAYMENT_TYPE = '6';

    /**
     * gift certificates payment type id
     * @var constants
     */
    CONST GIFTCARD_PAYMENT_TYPE_ID = 14;

    /**
     * Order info extended type
     * @var constant
     */
    CONST ORDER_INFO_EXTENDED_TYPE = 'extended';

    /**
     * Order info custom type
     * @var constant
     */
    CONST ORDER_INFO_CUSTOM_TYPE = 'custom';

    /**
     * Payment options module name
     * @var constant
     */
    CONST PAYMENT_OPTIONS_MODULE_NAME = 'pgw';

    /**
     * Kotak KMBL CCDC KEY
     * @var constant
     */
    CONST KOTAK_KMBL_CCDC_KEY = 'KOTAK_KMBL_CCDC';

    /**
     * Kotak KMBL NB KEY
     * @var constant
     */
    CONST KOTAK_KMBL_NB_KEY = 'KOTAK_KMBL_NB';

    /**
     * Payment retry module name
     * @var constant
     */
    CONST PAYMENT_RETRY_MODULE_NAME = 'payment_retry';

    /**
     * COD payment id
     * @var constant
     */
    const COD_PAYMENT_ID = 6;

    /**
     * MOMOE payment id
     * @var constant
     */
    const MOMOE_PAYMENT_ID = 73;

    /**
     * MOMOE Net Banking payment id
     * @var constant
     */
    const MOMOE_NB_PAYMENT_ID = 74;

    /**
     * MOMOE credit card payment type id
     * @var constant
     */
    const MOMOE_CC_TYPE_ID = 2;

    /**
     * MOMOE debit card payment type id
     * @var constant
     */
    const MOMOE_DC_TYPE_ID = 3;

    /**
     * Desktop platform
     * @var constant
     */
    const PLATFORM_DESKTOP = 'D';

    /**
     * Android platform
     * @var constant
     */
    const PLATFORM_ANDROID = 'A';

    /**
     * login user 
     * @var constant
     */
    const LOGIN_USER = 'L';

    /**
     * guest user 
     * @var constant
     */
    const GUEST_USER = 'G';

    /**
     * Convert to cod
     * @var constant
     */
    const CONVERT_TO_COD_MODULE_NAME = 'convert_to_cod';

    /**
     * Quick payment basic info
     * @var constant
     */
    CONST QUICK_PAYMENT_BASIC_INFO = 'quick_payment_basic';

    /**
     * Quick payment extended info
     * @var constant
     */
    CONST QUICK_PAYMENT_EXTENDED_INFO = 'quick_payment_extended';

    /**
     * Quick payment failed due to missing parameter like user_id
     * @var constant
     */
    CONST QUICK_PAYMENT_FAILED_MISSING_PARAM = 'quick_payment_failed';

    /**
     * Downtime notification current source
     * @var constant
     */
    CONST DOWNTIME_NOTIFICATION_CURRENT_SOURCE = 'PayU';

    /**
     * Wallet check failed due to missing parameter like profile id
     * @var constant
     */
    CONST WALLET_CHECK_FAILED_MISSING_PARAMETER = 'wallet_param_missing';

    /**
     * Wallet balance failed due to missing user id
     * @var constant
     */
    CONST WALLET_BALANCE_FAILED_MISSING_PARAMETER = 'wallet_balance_param_missing';

    /**
     * Tez SDK parameter name
     * @var constant
     */
    CONST TEZ_SDK_PARAM_NAME = 'TEZ';

    /**
     * Tez Payment Id
     * @var constant
     */
    CONST TEZ_PAYMENT_ID = 79;

    /**
     * Tez form name
     * @var constant
     */
    CONST TEZ_PAYMENT_TYPE = 19;

    /**
     * Tez payment option id
     * @var constant
     */
    CONST TEZ_PAYMENT_OPTION_ID = 187;

    /**
     * Quick payment key
     * @var constant
     */
    CONST QUICK_PAYMENT_KEY = 'quick_payment';

    /**
     * one step checkout key
     * @var constant
     */
    CONST ONE_STEP_CHECKOUT_KEY = 'one_step_checkout';

    /**
     * one step checkout extended info 
     * @var constant
     */
    CONST ONE_STEP_CHECKOUT_EXTENDED_INFO = 'one_step_checkout_extended';

    /**
     * one step checkout basic info 
     * @var constant
     */
    CONST ONE_STEP_CHECKOUT_BASIC_INFO = 'one_step_checkout_basic';

    /**
     * Payment rules pincode key
     * @var constant
     */
    CONST PAYMENT_RULES_KEY_PINCODE = 'pincode';

    /**
     * Payment rules category key
     * @var constant
     */
    CONST PAYMENT_RULES_KEY_CATEGORY = 'category';

    /**
     * Payment rules new user key
     * @var constant
     */
    CONST PAYMENT_RULES_KEY_NEW_USER = 'new_user';

    /**
     * Payment rules time key
     * @var constant
     */
    CONST PAYMENT_RULES_KEY_TIME = 'time';

    /**
     * Payment rules quantity key
     * @var constant
     */
    CONST PAYMENT_RULES_KEY_QUANTITY = 'quantity';

    /**
     * Payment rules quantity key
     * @var constant
     */
    CONST PAYMENT_RULES_KEY_CLIENT_ID = 'client_id';

    /**
     * Payment rules pincode object key
     * @var constant
     */
    CONST PAYMENT_RULES_PINCODE_OBJECT_KEY = 1;

    /**
     * Payment rules category object key
     * @var constant
     */
    CONST PAYMENT_RULES_CATEGORY_OBJECT_KEY = 2;

    /**
     * Payment rules time object key
     * @var constant
     */
    CONST PAYMENT_RULES_TIME_OBJECT_KEY = 3;

    /**
     * Payment rules new user object key
     * @var constant
     */
    CONST PAYMENT_RULES_NEW_USER_OBJECT_KEY = 4;

    /**
     * Payment rules quantity object key
     * @var constant
     */
    CONST PAYMENT_RULES_QUANTITY_OBJECT_KEY = 5;

    /**
     * Payment rules quantity object key
     * @var constant
     */
    CONST PAYMENT_RULES_CLIENT_ID_OBJECT_KEY = 6;

    /**
     * COD Payment option id
     * @var constant
     */
    CONST COD_PAYMENT_OPTION_ID = 61;

    /**
     * Payment rules min new user bit
     * @var constant
     */
    CONST PAYMENT_RULES_NEW_USER_MIN_RULE_BIT = 256;

    /**
     * Payment rules active status
     * @var constant
     */
    CONST PAYMENT_RULES_ACTIVE_STATUS = 1;

    /**
     * Payment rules module name
     * @var constant
     */
    CONST PAYMENT_RULES_MODULE_NAME = 'payment_rules';

    /**
     * config api site 
     * @var constant 
     */
    CONST API_SITE = 'api';

    /**
     * seamless flow constant
     * @var constant
     */
    CONST SEAMLESS_FLOW = 1;

    /**
     * tokenisation implementation 
     * @var constant
     */
    CONST TOKENISATION = 1;

    /**
     * default client id
     * @var constant
     */
    CONST DEFAULT_CLIENT_ID = 'pup_default_client_id';

    /**
     * CANCELLATION_BUCKET_ID_E
     * @var constant
     */
    const CANCELLATION_BUCKET_ID_E = 'E';

    /**
     * CANCELLATION_BUCKET_ID_N
     * @var constant
     */
    const CANCELLATION_BUCKET_ID_N = 'N';

    /**
     * Order Object Type
     * @var constant
     */
    const ORDER_OBJECT_TYPE = 'O';

    /**
     * constant for PAS payment id
     * @var constant 
     */
    CONST PAS_PAYMENT_ID = 86;

    /**
     * constant for PAS option id
     * @var constant 
     */
    CONST PAS_PAYMENT_OPTION_ID = 309;

    /**
     * constant for PAS as payment type id
     * @var constant 
     */
    CONST PAS_PAYMENT_TYPE_ID = 24;

    /**
     * profile type - Pay at store
     * @var constant
     */
    const PROFILE_TYPE_PAY_AT_STORE = 'M';

    /**
     * momoe payment option id
     * @var constant
     */
    const MOMOE_PAYMENT_OPTION_ID = 162;

    /**
     * upi payment option id
     * @var constant
     */
    const UPI_PAYMENT_OPTION_ID = 183;

    /**
     * paytm payment option id
     * @var constant
     */
    const PAYTM_PAYMENT_OPTION_ID = 118;

    /**
     * mobikwik payment option id
     * @var constant
     */
    const MOBIKWIK_PAYMENT_OPTION_ID = 304;

    /**
     * sbi net banking payment option id
     * @var constant
     */
    const SBI_NET_BANKING_PAYMENT_OPTION_ID = 34;

    /**
     * mobikwik payment id
     * @var constant
     */
    const MOBIKWIK_PAYMENT_ID = 82;

    /**
     * upi payment type id
     * @var constant
     */
    const UPI_PAYMENT_TYPE_ID = 18;

    /**
     * paytm payment type id
     * @var constant
     */
    const PAYTM_PAYMENT_TYPE_ID = 23;

    /**
     * mobikwik payment type id
     * @var constant
     */
    const MOBIKWIK_PAYMENT_TYPE_ID = 5;

    /**
     * sbi net banking payment type id
     * @var constant
     */
    const SBI_NET_BANKING_PAYMENT_TYPE_ID = 1;

    /**
     * Paytm seamless payment type id
     * @var constant
     */
    const PAYTM_SEAMLESS_PAYMENT_TYPE_ID = 27;

    /**
     * wallet payment type id
     * @var constant
     */
    const WALLET_PAYMENT_TYPE_ID = 5;

    /**
     * Mobile platform
     * @var constant
     */
    const PLATFORM_MOBILE = 'M';

    /**
     * paytm non-seamless payment type id
     * @var constant
     */
    const UPI_NON_SEAMLESS_PAYMENT_TYPE_ID = 29;

    /**
     * EXTRA_PAYMENT_REFUNDED_MANUALLY
     * @var constant
     */
    const EXTRA_PAYMENT_REFUNDED_MANUALLY = 2;

    /**
     * TB Payment option id
     * @var constant
     */
    const TB_PAYMENT_OPTION_ID = 319;

    /**
     * CLUES_PREPAYMENT_DETAILS_DATA
     * @var constant
     */
    const CLUES_PREPAYMENT_DETAILS_DATA = 'clues_prepayment_details_data';

    /**
     * CLUES_PREPAYMENT_DETAILS_DATA_HISTORY
     * @var constant
     */
    const CLUES_PREPAYMENT_DETAILS_DATA_HISTORY = 'clues_prepayment_details_data_history';

    /**
     * clues_prepayment_details_data primary key name 
     * @var constant
     */
    const clues_prepayment_details_data_primary_key = 'id';

    /**
     * PAYMENT_PAID_STATUS 
     * @var constant
     */
    const PAYMENT_PAID_STATUS = 1;

    /**
     * REFUND_MANAGER 
     * @var constant
     */
    const REFUND_MANAGER = 221;

    /**
     * PAYMENT_SUCESS 
     * @var constant
     */
    const PAYMENT_SUCCESS = 'success';

    /**
     * PAYMENT_MANUALLY_REFUNDED 
     * @var constant
     */
    const PAYMENT_MANUALLY_REFUNDED = 'manually_refuned';

    /**
     * PAYMENT_PARTIALLY_REFUNDED 
     * @var constant
     */
    const PAYMENT_PARTIALLY_REFUNDED = 'partially_refuned';

    /**
     * PAYMENT_FAILURE 
     * @var constant
     */
    const PAYMENT_FAILURE = 'failure';

    /**
     * PAYMENT_FAILED
     * @var constant
     */
    const PAYMENT_FAILED = 'failed';

    /**
     * Context for cart/order cod check
     * @var constant
     */
    CONST CONTEXT_CART_ORDER_COD_CHECK = 'cart_order_cod_check';

    /**
     * Context for pgw resquest
     * @var constant
     */
    CONST CONTEXT_PGW_REQUEST = 'pgw_request';

    /**
     * Context for payment internal
     * @var constant
     */
    CONST CONTEXT_PAYMENT_INTERNAL = 'payment_internal';

    /**
     * payment user id
     * @var constant 
     */
    CONST PAYMENT_USER_ID = 38199908;

    /**
     * EXTRA_PAYMENT_REFUNDED_PARTIALLY
     * @var constant 
     */
    CONST EXTRA_PAYMENT_REFUNDED_PARTIALLY = 3;

    /**
     * Context for send payment failed link internal
     * @var constant
     */
    CONST CONTEXT_SEND_PAYMENT_LINK_INTERNAL = 'send_payment_failed_link';

    /**
     * module name for fetching client payment rules
     * @var constant
     */
    CONST CLIENT_WISE_PAYMENT_OPTIONS_RULE_MODULE = 'payment';

    /**
     * cart amount bounds by payment type
     * @var constant
     */
    CONST CART_ORDER_AMOUNT_RULE_BY_PAYMENT_TYPE = 'cart_order_amount_limit_by_payment_type';

    /**
     * cart amount bounds by payment gateway
     * @var constant
     */
    CONST CART_ORDER_AMOUNT_RULE_BY_PAYMENT_GATEWAY = 'cart_order_amount_limit_by_payment_gateway';

    /**
     * cart amount bounds by payment option
     * @var constant
     */
    CONST CART_ORDER_AMOUNT_RULE_BY_PAYMENT_OPTION = 'cart_order_amount_limit_by_payment_option';

    /**
     * new ui reorder parameter
     * @var constant
     */
    CONST NEW_UI_REORDER_PARAM = 'new_ui_reorder';

    /**
     * production environment - clues_envionment_platform_dependencies
     * @var constant
     */
    CONST PRODUCTION_ENVIRONMENT_KEY = 0;

    /**
     * momoe cc payment option id
     * @var constant
     */
    const MOMOE_CC_OPTION_ID = 162;

    /**
     * momoe dc payment option id
     * @var constant
     */
    const MOMOE_DC_OPTION_ID = 163;

    /**
     * constant for payment gateway expense
     * @var constant
     */
    const PG_EXPENSE = 'pg_expense';

    /**
     * constant for approx payment gateway expense
     * @var constant
     */
    CONST APPX_PG_EXP = 'apgexp';

    /**
     * constant for approx payment gateway commission rate
     * @var constant
     */
    CONST APPX_PG_COMM_RATE = 'apgcr';

    /**
     * constant for scratch card offer apply
     * @var constant
     */
    CONST OFFER_APPLY = 'apply';

    /**
     * constant for scratch card offer redeem
     * @var constant
     */
    CONST OFFER_REDEEMED = 'redeem';

    /**
     * constant for scratch card offer on ecb
     * @var constant
     */
    CONST ECB_OFFER_ON_SCRATCH = 1;

    /**
     * constant for scratch card credit status before scratch card is scratched
     * @var constant
     */
    CONST OFFER_BEFORE_SCRATCH_STATUS = 0;

    /**
     * constant for scratch card credit status after user has scratched the scratch card
     * @var constant
     */
    CONST OFFER_AFTER_SCRATCH_STATUS = 1;

    /**
     * constant for scratch card credit status for processing status
     * @var constant
     */
    CONST OFFER_PROCESSING_STATUS = 2;

    /**
     * constant for scratch card credit status for success status
     * @var constant
     */
    CONST OFFER_SUCCESS_STATUS = 3;

    /**
     * constant for scratch card credit status for failed status
     * @var constant
     */
    CONST OFFER_FAILED_STATUS = 4;

    /**
     * constant for scratch card description msg
     * @var constant
     */
    CONST SCRATCH_CARD_DESC = 'Scratch card';

    /**
     * constant for scratch card delivered status
     * @var constant
     */
    CONST SCRATCH_CARD_DELIVERED = 'H';

    /**
     * constant for scratch card paid status
     * @var constant
     */
    CONST SCRATCH_CARD_PAID = 'P';

    /**
     * constant for scratch card cb offer type
     * @var constant
     */
    CONST SCRATCH_CARD_CB_OFFER_TYPE = 'CluesBucks';

    /**
     * constant for scratch card cb+ offer type
     * @var constant
     */
    CONST SCRATCH_CARD_CB_PLUS_OFFER_TYPE = 'CluesBucks+';

    /**
     * const for delete card status
     * @var integer
     */
    const DELETE_STATUS_FOR_USER_CARD = 3;

    /**
     * const for delete card status at pgw end
     * @var integer
     */
    const DELETE_STATUS_FOR_USER_CARD_AT_PGW_END = 2;

    /**
     * const for new card status
     * @var integer
     */
    const INITIAL_STATUS_FOR_USER_CARD = 1;

    /**
     * const for deleted card msg
     * @var constant
     */
    const DELETE_CARD_MSG = 'card deleted';

    /**
     * const for deleted card msg at pgw end
     * @var constant
     */
    const DELETE_CARD_MSG_AT_PGW_END = 'card deleted at pgw end';

    /**
     * constant for 2C2P pgw payment id
     * @var constant 
     */
    CONST Pgw2C2P_PAYMENT_ID = 1;

    /**
     * constant for 2c2p card success response codes
     * @var constant
     */
    CONST Pgw2C2P_CARD_SUCCESS_RESPONSE_CODES = ['00'];

    /**
     * const for card successfully added msg
     * @var constant
     */
    const CARD_ADDED_SUCCESS_MSG = 'Card added successfully';

    /**
     * const for card successfully deleted msg
     * @var constant
     */
    const CARD_DELETE_MSG = 'Card deleted successfully';
    
    /**
     * const for card nick-name updated successfully
     * @var constant
     */
    const CARD_NICKNAME_MSG = 'Card nick-name updated successfully';
    
    /**
     * const for card set as default updated successfully
     * @var constant
     */
    const CARD_SET_DEFAULT_MSG = 'Card set as default succuessfully';

    /**
     * const for user card info table
     * @var constant
     */
    const USER_CARD_INFO_TABLE = 'pup_user_card_info';

    /**
     * const for user card info history table
     * @var constant
     */
    const USER_CARD_INFO_HISTORY_TABLE = 'pup_user_card_info_history';

    /**
     * Card operations module name
     * @var constant
     */
    CONST CARD_OPERATIONS_MODULE_NAME = 'card_operations';
}
