<?php

namespace clues\model\payment\exception;

use clues\system\exception\CommonException;
use clues\model\payment\exception\PaymentStatus;
use clues\model\payment\PaymentConstants;

/**
 * This class is used for handling payment exceptions
 * @class PaymentException
 * @access public
 * @param array $additionalInfo
 * <p>array(
 * 'line' => 'line no',
 * 'file' => 'file',
 * 'previous'=>'previous error',
 * 'module'=>'module name',
 * 'domain'=>'domain name',
 * 'level'=>'error level',
 * 'message' => 'message'
 * )
 * </p>
 * @param interger $code
 * @package model/payment/exception
 */
class PaymentException extends CommonException {

    public static $type = PaymentConstants::DOMAIN_NAME;

    /**
     * class constructor
     * @method __construct
     * @access public
     * @param interger $code exception code
     * @param array $additionalInfo <pre>
     * array(
     *      'field1'=> 'field data','field2'=> 'field data','field3'=> 'field data',
     *      'field4'=> 'field data','error_name'=>'error name',
     *      'additional_data'=>array(
     *          'file' => 'file','line' => 'line no','method'=>'method/function name','previous'=>'previous error'
     *          'module'=>'module name','domain'=>'domain name','level'=>'level for logging',
     *          'message'=>'user message','input_params'=>'input parameters string/array/integer',
     *          'placeholders'=>array('data1','data2',....),'custom_key1'=>'data of custom key',......
     *      )
     * )</pre>
     * @return void
     */
    public function __construct($code, array $additionalInfo = array()) {
        $previous = (isset($additionalInfo['additional_data']['previous']) && !empty($additionalInfo['additional_data']['previous'])) ? $additionalInfo['additional_data']['previous'] : null;
        $file = (isset($additionalInfo['additional_data']['file']) && !empty($additionalInfo['additional_data']['file'])) ? $additionalInfo['additional_data']['file'] : null;
        $line = (isset($additionalInfo['additional_data']['line']) && !empty($additionalInfo['additional_data']['line'])) ? $additionalInfo['additional_data']['line'] : null;
        parent::__construct($code, $previous, $file, $line, $additionalInfo);
    }

    /**
     * This method is used to get exception codes
     * @method getCodes
     * @access public static
     * @param boolean $allCodes
     * @return array
     */
    public static function getCodes($allCodes = false) {
        return PaymentStatus::getCodes($allCodes);
    }

}
