<?php

namespace clues\model\payment\exception;

use clues\system\exception\Status;

/**
 * This class is used for payment status messages
 * @class PaymentStatus
 * @access public
 * @package model/payment/exception
 */
class PaymentStatus extends Status {

    /**
     * exception codes
     * @var array 
     */
    const ERROR_CODE_PAYMENT_LINK_VALIDATION_FAILS = 6001;

    /**
     * exception codes for EMI
     * @var array 
     */
    const EMI_STATUS_EMPTY_PARAM = 6502;

    /**
     * exception codes for EMI not availbe for priduct
     * @var array 
     */
    const EMI_STATUS_EMI_NOT_AVAILABLE = 6503;

    /**
     * exception codes for invalid product id
     * @var array 
     */
    const EMI_STATUS_INVALID_PRODUCT = 6504;

    /**
     * exception codes for Cart total less than mininum require amount
     * @var array 
     */
    const EMI_STATUS_CART_AMOUNT_LESS_THAN_REQ_AMOUNT = 6505;

    /**
     * exception codes Max txnid allowed limit reach
     * @var array 
     */
    const MAX_LIMIT_REACH_TXNID = 6508;

    /**
     * exception codes for card details missing
     * @var array 
     */
    const CARD_DETAILS_MISSING = 11000;

    /**
     * exception codes for card already exists
     * @var array 
     */
    const CARD_ALREADY_EXISTS = 11001;

    /**
     * exception codes for user id missing
     * @var array 
     */
    const USER_ID_MISSING = 11002;

    /**
     * exception codes for invalid card details
     * @var array 
     */
    const PUP_TOKEN_MISSING = 11003;

    /**
     * exception codes for card not saved at pgw end
     * @var array 
     */
    const CARD_NOT_SAVED_AT_PGW_END = 11004;

    /**
     * exception codes for invalid delete because booking present with this card
     * @var array 
     */
    const INVALID_DELETE_BOOKING_ALREADY_PRESENT = 11005;

    /**
     * exception codes for invalid delete because booking present with this card
     * @var array 
     */
    const CARD_NAME_ALREADY_EXISTS = 11006;

    /**
     * exception codes for invalid delete because booking present with this card
     * @var array 
     */
    const CARD_ALREADY_SET_AS_DEFAULT = 11007;

    /**
     * exception codes for invalid delete because booking present with this card
     * @var array 
     */
    const INVALID_OPERATION = 11008;

    /**
     * exception codes for invalid delete because booking present with this card
     * @var array 
     */
    const PROVIDE_CARD_NICKNAME = 11009;

    /**
     * exception codes for card not deleted at pgw end
     * @var array 
     */
    const CARD_NOT_DELETED_AT_PGW_END = 11010;

    /**
     * invalid token
     * @var constant
     */
    const INVALID_TOKEN = 11011;

    /**
     * invalid card expiry
     * @var constant
     */
    const INVALID_CARD_EXPIRY = 11012;

    /**
     * card expired
     * @var constant
     */
    const CARD_EXPIRED = 11013;

    /**
     * invalid card no
     * @var constant
     */
    const INVALID_CARD_NO = 11014;

    /**
     * invalid card cvv
     * @var constant
     */
    const INVALID_CARD_CVV = 11015;

    /**
     * invalid card details
     * @var constant
     */
    const INVALID_CARD_DETAILS = 11016;

    /**
     * exception codes
     * @var array 
     */
    public static $codes = array(
        self::ERROR_CODE_PAYMENT_LINK_VALIDATION_FAILS,
        self::EMI_STATUS_EMPTY_PARAM,
        self::EMI_STATUS_EMI_NOT_AVAILABLE,
        self::EMI_STATUS_INVALID_PRODUCT,
        self::EMI_STATUS_CART_AMOUNT_LESS_THAN_REQ_AMOUNT,
        self::MAX_LIMIT_REACH_TXNID,
        self::CARD_DETAILS_MISSING,
        self::CARD_ALREADY_EXISTS,
        self::USER_ID_MISSING,
        self::PUP_TOKEN_MISSING,
        self::CARD_NOT_SAVED_AT_PGW_END,
        self::INVALID_DELETE_BOOKING_ALREADY_PRESENT,
        self::CARD_NAME_ALREADY_EXISTS,
        self::CARD_ALREADY_SET_AS_DEFAULT,
        self::INVALID_OPERATION,
        self::PROVIDE_CARD_NICKNAME,
        self::CARD_NOT_DELETED_AT_PGW_END,
        self::INVALID_TOKEN,
        self::INVALID_CARD_EXPIRY,
        self::CARD_EXPIRED,
        self::INVALID_CARD_NO,
        self::INVALID_CARD_CVV,
        self::INVALID_CARD_DETAILS
    );

}
