<?php

namespace clues\model\pgw\PGWHashManager;

use clues\system\exception\Status;
use clues\model\pgw\PgwModelConstants;
use clues\model\pgw\exception\PgwException;
use clues\model\pgw\PGWHashManager\PGWHashConstants;
use clues\system\BasePlatform;
/**
 * This class is used to perform all common operations related to pgw hash generation
 * @class PGWHashBase
 * @access public
 * @package model/pgw/PGWHashManager
 * @category pgw
 */
abstract class PGWHashBase extends BasePlatform implements PGWHashConstants {

    /**
     * generate hash for request
     * @method generateRequestHash
     * @param array $inputParam 
     * @param object $orderInfo
     * @access public
     * @return string
     */
    abstract public function generateRequestHash(array $inputParam, $orderInfo);

    /**
     * generate hash for response
     * @method generateResponseHash
     * @param array $inputParam 
     * @param object $orderInfo
     * @access public
     * @return string
     */
    abstract public function generateResponseHash(array $inputParam, $orderInfo);

    /**
     * generate hash for notify response
     * @method generateNotifyResponseHash
     * @param array $inputParam 
     * @param object $orderInfo
     * @access public
     * @throws Exception
     * @return string
     */
    public function generateNotifyResponseHash(array $inputParam, $orderInfo) {
        $exceptionData = array();
        $exceptionData['error_name'] = 'Method not found ' . __METHOD__;
        $additionalInfo = array();
        $additionalInfo['file'] = __FILE__;
        $additionalInfo['line'] = __LINE__;
        $additionalInfo['level'] = Logger::ERROR;
        $additionalInfo['domain'] = PgwModelConstants::DOMAIN_NAME;
        $additionalInfo['module'] = PgwModelConstants::MODULE_NAME;
        $additionalInfo['method'] = __METHOD__;
        $additionalInfo['input_parms'] = $inputParam;
        $additionalInfo['order_info'] = $orderInfo;
        $exceptionData['additional_data'] = $additionalInfo;
        throw new PgwException(Status::METHOD_NOT_EXIST, $exceptionData);
    }

}
