<?php

namespace clues\model\pgw\PGWHashManager;

/**
 * This interface is used to all hash constants
 * @class PGWHashInterface
 * @access public
 * @package model/pgw/PGWHashManager
 * @category pgw
 */
interface PGWHashConstants {

    /**
     * Olamoney hash class name
     * @var constants
     */
    CONST OLAMONEY_HASH_CLASS = 'OlaMoneyHash';

    /**
     * Momoe hash class name
     * @var constants
     */
    CONST MOMOE_HASH_CLASS = 'MomoeHash';

    /**
     * Mobikwik non-seamless hash class name
     * @var constants
     */
    CONST MOBIKWIK_HASH_CLASS = 'MobikwikHash';

    /**
     * Mobikwik seamless hash class name
     * @var constants
     */
    CONST MOBIKWIK_SEAMLESS_HASH_CLASS = 'MobikwikSeamlessHash';

    /**
     * BillDesk hash class name
     * @var constants
     */
    CONST BILLDESK_HASH_CLASS = 'BillDeskHash';

    /**
     * Paytm non seamless hash class name
     * @var constants
     */
    CONST PAYTM_HASH_CLASS = 'PaytmHash';

    /**
     * EpayLater hash class name
     * @var constants
     */
    CONST EPAYLATER_HASH_CLASS = 'EpayLaterHash';

    /**
     * Payu upi qr hash class name
     * @var constants
     */
    CONST PAYU_UPI_QR_HASH_CLASS = 'PayuUpiQrHash';

    /**
     * Jio money hash class name
     * @var constants
     */
    CONST JIO_WALLET_HASH_CLASS = 'JioWalletHash';

}
