<?php

namespace clues\model\pgw\exception;

use clues\system\exception\CommonException;
use clues\model\pgw\exception\PgwStatus;
use clues\model\pgw\PgwModelConstants;

class PgwException extends CommonException {

    /**
     * Exception type
     * @var constant
     */
    public static $type = PgwModelConstants::MODULE_NAME;

    /**
     * Demo Exception class constructor
     * @method __construct
     * @access public
     * @param interger $code exception code
     * @param array $additionalInfo 
     * <p>array(
     *      'field1'=> 'field data','field2'=> 'field data','field3'=> 'field data',
     *      'field4'=> 'field data','error_name'=>'error name',
     *      'additional_data'=>array(
     *          'file' => 'file','line' => 'line no','method'=>'method/function name','previous'=>'previous error'
     *          'module'=>'module name','domain'=>'domain name','level'=>'level for logging',
     *          'message'=>'user message','input_params'=>'input parameters string/array/integer',
     *          'placeholders'=>array('data1','data2',....),'custom_key1'=>'data of custom key',......
     *      )
     * )
     * </p>
     * @return void
     */
    public function __construct($code, array $additionalInfo = array()) {
        $previous = (isset($additionalInfo['additional_data']['previous']) && !empty($additionalInfo['additional_data']['previous'])) ? $additionalInfo['additional_data']['previous'] : null;
        $file = (isset($additionalInfo['additional_data']['file']) && !empty($additionalInfo['additional_data']['file'])) ? $additionalInfo['additional_data']['file'] : null;
        $line = (isset($additionalInfo['additional_data']['line']) && !empty($additionalInfo['additional_data']['line'])) ? $additionalInfo['additional_data']['line'] : null;
        parent::__construct($code, $previous, $file, $line, $additionalInfo);
    }

    /**
     * This method is used to get exception codes
     * @method getCodes
     * @access public static
     * @param boolean $allCodes
     * @return array
     */
    public static function getCodes($allCodes = false) {
        return PgwStatus::getCodes($allCodes);
    }

}
