<?php

namespace clues\model\pgwVerify;

use clues\system\BasePlatform;
use clues\model\pgwVerify\PgwVerifyConstants;
use clues\system\DI;

/**
 * This class is used to perform all common operations related to payment
 * @class PgwVerifyBase
 * @access public
 * @package model/pgwVerify
 * @category pgw
 */
abstract class PgwVerifyBase extends BasePlatform implements PgwVerifyConstants {

    /**
     * array for pg verify response caching in same orders
     * @var array 
     */
    protected $verifyOrderCache;

    /**
     * Addition pgw data
     * @var array
     */
    public $additionalData = array();

    /**
     * Db object pgw data
     * @access public
     * @var mixed 
     */
    public $_pgwVerifyDBO;

    /**
     * Class constructor
     * @method __construct
     * @access public
     * @return void
     */
    public function __construct(array $additionalData = array()) {
        parent::__construct();
        $this->additionalData = $additionalData;
        DI::Map('PgwVerifyDBOperations', 'clues\\model\\pgwVerify\\PgwVerifyDBOperations');
        $this->_pgwVerifyDBO = DI::Singleton('PgwVerifyDBOperations');
    }

    /**
     * Save response from pgw after payment
     * @method getPgwTransaction
     * @param array $inputParams input params
     * @access public
     * @return array
     */
    abstract public function getPgwTransaction(array $inputParams);

    /**
     * Get Data for redirection
     * @method verifyPgTransaction
     * @param mixed $pgTransaction array pgw transaction
     * @param array $inputParams array input params
     * @access public
     * @return array
     */
    abstract public function verifyPgTransaction($pgTransaction, array $inputParams);

    /**
     * Get Data for redirection
     * @method createPrepaymentData
     * @param mixed $pgTransaction array pgw transaction
     * @param array $order array Order details
     * @access public
     * @return array
     */
    abstract public function createPrepaymentData($pgTransaction, array $order);

    /**
     * method to get discounted amount for updating post promotion
     * @method getNetPaymentAmount
     * @access public
     * @param array $pgResponse response from payment gateway
     * @return int discounted value
     */
    protected function getNetPaymentAmount($pgResponse) {
        
    }

    /**
     * method to check sc order id valid or not in case of add money for pgw verify cron
     * @method checkVerifyValidationByPPDFlag
     * @access public
     * @param String $flag
     * @return bool
     */
    public function checkVerifyValidationByPPDFlag($flag) {
        return true;
    }

    /**
     * This method is used to get response data
     * @method getCurlResponse
     * @param string $url 
     * @param array $params 
     * @param array $header
     * @access protected
     * @return array $responseArray
     */
    protected function getCurlResponse($url, $params, array $header = array()) {
        $headerArray = array_merge(array('Content-Type: application/*+json'), $header);
        if (is_array($params)) {
            $paramsString = json_encode($params);
        } else {
            $paramsString = $params;
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $paramsString);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        $responseArray = isset($response) && !empty($response) ? json_decode($response, true) : array();
        return $responseArray;
    }

    /**
     * This method is used to get pgw txn data
     * @method getPgwMetaData
     * @access public
     * @param array $response
     * @return array
     */
    public function getPgwMetaData($response = null) {
        if (empty($response) || !is_array($response)) {
            return array();
        }
        $setArray = array();
        foreach (static::$_fieldsForPrepaymentDetails as $prepaymentKey => $value) {
            if (isset($response[$prepaymentKey]) && !empty($response[$prepaymentKey])) {
                $setArray[$value] = $response[$prepaymentKey];
            }
        }
        return $setArray;
    }

}
