<?php

namespace clues\model\pgwVerify;

/**
 * Interface for Pgw verify constants
 * @interface PgwVerifyConstants
 * @category model interface
 * @package model/pgwVerify
 * @note remove useless constants
 */
interface PgwVerifyConstants {

    /**
     * pgw domain name
     * @var constants
     */
    const DOMAIN_NAME = 'payment';

    /**
     * pgw model name
     * @var constants
     */
    const MODULE_NAME = 'pgw';

    /**
     * Admin user id
     * @var constant
     */
    CONST ADMIN_USER_ID = 2;

    /**
     * old prepayment id key
     * @var constant
     */
    CONST OLD_PREPAYMENT_ID_KEY = 'old_prepayment_id';

    /**
     * verify response key
     * @var constant
     */
    CONST PGW_VERIFY_RESPONSE_KEY = 'verify_response';

    /**
     * constant for pgw verify retry check rule name
     * @var constant 
     */
    CONST PGW_VERIFY_RETRY_CHECK_RULE = 'pgw_verify_retry_check';

    /**
     * constant for max retry count check
     * @var constant 
     */
    CONST MAX_PGW_VERIFY_RETRY = 10;

    /**
     * constant for pgw next pickup
     * @var constant 
     */
    CONST PGW_VERIFY_NEXT_PICKUP = 'next_pickup_time';

    /**
     * constant for pgw order id key
     * @var constant 
     */
    CONST PGW_ORDER_REQ_ID = 'order_pgw_req_id';

    /**
     * constant for retry count number
     * @var constant 
     */
    CONST RETRY_COUNT = 'retry_count';

    /**
     * constant for retry time gap
     * @var constant 
     */
    CONST RETRY_TIME_GAP = 1800;

    /**
     * constant for retry count value
     * @var constant 
     */
    CONST RETRY_COUNT_VALUE = 3;

    /**
     * constant for payment status
     * @var constant 
     */
    CONST PAYMENT_STATUS_KEY = 'payment_status';

    /**
     * Pgw txn id
     * @var constant
     */
    CONST PGW_TXN_ID = 'pgw_txn_id';

    /**
     * Pgw forwarded name
     * @var constant
     */
    CONST PG_FORWARDED_NAME = 'pgw_name';

    /**
     * key for prepayment data that tells bank code of txn
     * @var constant
     */
    CONST PG_BANK_CODE = 'pg_bank_code';

    /**
     * key for prepayment data that tells card mode (cc/dc) of txn
     * @var constant
     */
    CONST PG_CARD_MODE = 'pg_card_mode';

    /**
     * key for prepayment data that tells obf card number
     * @var constant
     */
    CONST CARD_NUMBER = 'card_number';

    /**
     * key for prepayment data that tells upi virtual payment address
     * @var constant
     */
    CONST UPI_VPA = 'upi_vpa';

    /**
     * key for prepayment data that tells pg bank ref id
     * @var constant
     */
    CONST PG_BANK_REF_ID = 'pg_bank_ref_id';

    /**
     * key for prepayment data that tells whether txn was done via a saved card or not
     * @var constant
     */
    CONST PG_IS_SAVED_CARD = 'txn_via_saved_card';

    /**
     * key for prepayment data that tells card type of txn
     * @var constant
     */
    CONST PG_CARD_TYPE = 'pg_card_type';

    /**
     * key for prepayment data that tells old prepayment id
     * @var constant 
     */
    CONST OLD_PREPAYMENT_ID = 'old_prepayment_id';

    /**
     * constant for payment successful status
     * @var constant
     */
    CONST PAYMENT_SUCCESS_STATUS = 1;

    /**
     * constant for payment mark success
     * @var constant
     */
    CONST PAYMENT_MARKED_SUCCESSFUL = 'payment_mark_success';
    
    /**
     * constant for pgw reference no
     * @var constant 
     */
    CONST PGW_REF_NO = 'referenceNo';

    /**
     * constant for pgw approval code
     * @var constant 
     */
    CONST PGW_APPROVAL_CODE = 'approvalCode';

    /**
     * constant for 2C2P pgw name
     * @var constant 
     */
    CONST Pgw2C2P = '2C2P';

    /**
     * constant for 2C2P pgw payment id
     * @var constant 
     */
    CONST Pgw2C2P_PAYMENT_ID = 1;

    /**
     * default client id
     * @var constant
     */
    CONST DEFAULT_CLIENT_ID = 'pup_default_client_id';

    /**
     * constant for payment module id
     * @var constant 
     */
    CONST PAYMENT_MODULE_ID = 18;

    /**
     * constant for notify data keys to client
     * @var constant 
     */
    CONST NOTIFY_DATA_KEYS = ['order_id', 'payment_id', 'payment_option_id', 'emi_id', 'emi_name', 'payment_type_id', 'pgw_type', 'pgw', 'pgw_option_name', 'payment_status', 'udf_payment_type', 'pgw_txn_id', 'card_number', 'pgw_order_id', 'client_order_id', 'prepayment_details_auto_increment_id', 'status', 'created_timestamp', 'created', 'updated', 'updated_by', 'created_by', 'payment_received_amt', 'direcpayreferenceid', 'flag', 'payment_status_info'];

    /**
     * constant for atom verify source
     * @var constant 
     */
    CONST ATOM_VERIFY_SOURCE = 1;

    /**
     * key for prepayment data that tells card token after tokenisation
     * @var constant
     */
    CONST PG_CARD_TOKEN = 'card_token';

    /**
     * const for user card info table
     * @var constant
     */
    const USER_CARD_INFO_TABLE = 'pup_user_card_info';

    /**
     * const for user card info history table
     * @var constant
     */
    const USER_CARD_INFO_HISTORY_TABLE = 'pup_user_card_info_history';

}