<?php

namespace clues\model\pgwVerify\util;

/**
 * this class is used for encrypting and decrypting raw data
 * @class EncryptDecryptRSA
 * @access public
 * @author aditya.mehrotra
 * @package util
 */
class EncryptDecrypt {

    /**
     * key for encryption or decryption
     * @access private
     */
    private $_encDncKey;

    /**
     * This method is used to set key for decryption/decryption
     * @method setKey
     * @access public
     * @param string $encDncKey
     * @return void
     */
    public function setKey($encDncKey) {
        $this->_encDncKey = $encDncKey;
    }

    /**
     * This method is used to get key for decryption/decryption
     * @method getKey
     * @access public
     * @param string $encDncKey
     * @return void
     */
    public function getKey() {
        return $this->_encDncKey;
    }

    /**
     * this method is used to decrypt data
     * @method encrypt
     * @access public
     * @param string $dataForEnc
     * @param string $encMethod method for encryption
     * @return string base 64 encoded string
     */
    public function encrypt($dataForEnc, $encMethod = 'aes-256-ctr') {
        $encrypted = null;
        if (!empty($this->_encDncKey) && is_string($dataForEnc)) {
            $numBytes = openssl_cipher_iv_length($encMethod);
            $iv = openssl_random_pseudo_bytes($numBytes);
            $opts = OPENSSL_RAW_DATA; // tells openssl_encrypt() to return the cipherText as raw data. By default, it returns it Base64-encoded.
            $tempEncryptedString = openssl_encrypt($dataForEnc, $encMethod, $this->_encDncKey, $opts, $iv);
            $encryptedString = $iv . $tempEncryptedString;
            $encrypted = base64_encode($encryptedString);
            if ($encrypted === false) {
                throw new \Exception('Encryption failed: ' . openssl_error_string());
            }
        }
        return $encrypted;
    }

    /**
     * this method is used to decrypt data
     * @method decrypt
     * @access public
     * @param string $dataForDec base 64 encoded string
     * @param string $decMethod method for encryption
     * @return @mixed
     */
    public function decrypt($dataForDec, $decMethod = 'aes-256-ctr') {
        $decrypted = null;
        if (!empty($this->_encDncKey) && !empty($dataForDec)) {
            $dataForDec = base64_decode($dataForDec);
            $numBytes = openssl_cipher_iv_length($decMethod);
            // and do an integrity check on the size.
            if (strlen($dataForDec) < $numBytes) {
                throw new \Exception('data length ' . strlen($dataForDec) . " is less than iv length $numBytes");
            }
            // Extract the initialisation vector and encrypted data
            $iv = substr($dataForDec, 0, $numBytes);
            $dataForDec = substr($dataForDec, $numBytes);
            $opts = OPENSSL_RAW_DATA;
            $decrypted = openssl_decrypt($dataForDec, $decMethod, $this->_encDncKey, $opts, $iv);
            if ($decrypted === false) {
                throw new \Exception('decryption failed: ' . openssl_error_string());
            }
        }
        return $decrypted;
    }

}
